/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.TempFile;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.io.test.ThrowOnCloseInputStream;
import org.apache.commons.io.test.ThrowOnFlushAndCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOUtilsCopyTest {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    @Test
    public void testCopy_byteArrayOutputStreamToInputStream() throws Exception {
        java.io.ByteArrayOutputStream out = new java.io.ByteArrayOutputStream();
        out.write(this.inData);
        QueueInputStream in = IOUtils.copy(out);
        byte[] inData2 = new byte[4097];
        int inSize = in.read(inData2);
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)inSize, (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])inData2, (String)"Content differs");
    }

    @Test
    public void testCopy_byteArrayOutputStreamToInputStream_nullOutputStream() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(null));
    }

    @Test
    public void testCopy_inputStreamToOutputStream() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        int count = IOUtils.copy(in, (OutputStream)out);
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
        Assertions.assertEquals((int)this.inData.length, (int)count);
    }

    @Test
    public void testCopy_inputStreamToOutputStream_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream in = new NullInputStream(0x80000000L);
        NullOutputStream out = NullOutputStream.INSTANCE;
        Assertions.assertEquals((int)-1, (int)IOUtils.copy((InputStream)in, (OutputStream)out));
        in.init();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copyLarge(in, out), (String)"copyLarge()");
    }

    @Test
    public void testCopy_inputStreamToOutputStream_nullIn() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((InputStream)null, out));
    }

    @Test
    public void testCopy_inputStreamToOutputStream_nullOut() {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(in, (OutputStream)null));
    }

    @Test
    public void testCopy_inputStreamToOutputStreamWithBufferSize() throws Exception {
        this.testCopy_inputStreamToOutputStreamWithBufferSize(1);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(2);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(4);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(8);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(16);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(32);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(64);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(128);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(256);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(512);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(1024);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(2048);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(4096);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(8192);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(16384);
    }

    private void testCopy_inputStreamToOutputStreamWithBufferSize(int bufferSize) throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        long count = IOUtils.copy(in, (OutputStream)out, bufferSize);
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
        Assertions.assertEquals((long)this.inData.length, (long)count);
    }

    @Test
    public void testCopy_inputStreamToWriter() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.copy(in, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.copy(in, (Writer)writer, "UTF8");
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_8).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullEncoding() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.copy(in, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullIn() {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(null, writer, "UTF8"));
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullOut() {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(in, null, "UTF8"));
    }

    @Test
    public void testCopy_inputStreamToWriter_nullIn() {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((InputStream)null, writer));
    }

    @Test
    public void testCopy_inputStreamToWriter_nullOut() {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(in, (Writer)null));
    }

    @Test
    public void testCopy_readerToAppendable() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        long count = IOUtils.copy((Reader)reader, (Appendable)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((long)this.inData.length, (long)count, (String)"The number of characters returned by copy is wrong");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToAppendable_IO84() throws Exception {
        long size = 0x80000000L;
        NullReader reader = new NullReader(0x80000000L);
        NullWriter writer = new NullWriter();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copy((Reader)reader, (Appendable)writer));
        ((Reader)reader).close();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copyLarge(reader, writer), (String)"copy()");
    }

    @Test
    public void testCopy_readerToAppendable_nullIn() {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(null, writer));
    }

    @Test
    public void testCopy_readerToAppendable_nullOut() {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(reader, (Appendable)null));
    }

    @Test
    public void testCopy_readerToOutputStream() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)out);
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)out, "UTF16");
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullEncoding() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)out, (String)null);
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullIn() {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(null, out, "UTF16"));
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullOut() {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(reader, null, "UTF16"));
    }

    @Test
    public void testCopy_readerToOutputStream_nullIn() {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)null, out));
    }

    @Test
    public void testCopy_readerToOutputStream_nullOut() {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(reader, (OutputStream)null));
    }

    @Test
    public void testCopy_readerToWriter() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        int count = IOUtils.copy((Reader)reader, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)count, (String)"The number of characters returned by copy is wrong");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToWriter_IO84() throws Exception {
        long size = 0x80000000L;
        NullReader reader = new NullReader(0x80000000L);
        NullWriter writer = new NullWriter();
        Assertions.assertEquals((int)-1, (int)IOUtils.copy((Reader)reader, (Writer)writer));
        ((Reader)reader).close();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copyLarge(reader, writer), (String)"copyLarge()");
    }

    @Test
    public void testCopy_readerToWriter_nullIn() {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)null, writer));
    }

    @Test
    public void testCopy_readerToWriter_nullOut() {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(reader, (Writer)null));
    }

    @Test
    public void testCopy_URLToFile() throws Exception {
        String name = "/org/apache/commons/io/abitmorethan16k.txt";
        URL in = this.getClass().getResource("/org/apache/commons/io/abitmorethan16k.txt");
        Assertions.assertNotNull((Object)in, (String)"/org/apache/commons/io/abitmorethan16k.txt");
        try (TempFile path = TempFile.create("testCopy_URLToFile", ".txt", new FileAttribute[0]);){
            IOUtils.copy(in, path.toFile());
            Assertions.assertArrayEquals((byte[])Files.readAllBytes(Paths.get("src/test/resources/org/apache/commons/io/abitmorethan16k.txt", new String[0])), (byte[])Files.readAllBytes(path.get()));
        }
    }

    @Test
    public void testCopy_URLToOutputStream() throws Exception {
        String name = "/org/apache/commons/io/abitmorethan16k.txt";
        URL in = this.getClass().getResource("/org/apache/commons/io/abitmorethan16k.txt");
        Assertions.assertNotNull((Object)in, (String)"/org/apache/commons/io/abitmorethan16k.txt");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        IOUtils.copy(in, (OutputStream)baout);
        Assertions.assertArrayEquals((byte[])Files.readAllBytes(Paths.get("src/test/resources/org/apache/commons/io/abitmorethan16k.txt", new String[0])), (byte[])baout.toByteArray());
    }
}

