/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.build.AbstractOrigin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public abstract class AbstractOriginTest<T, B extends AbstractOrigin<T, B>> {
    protected static final String FILE_RES_RO = "/org/apache/commons/io/test-file-20byteslength.bin";
    protected static final String FILE_NAME_RO = "src/test/resources/org/apache/commons/io/test-file-20byteslength.bin";
    protected static final String FILE_NAME_RW = "target/" + AbstractOriginTest.class.getSimpleName() + ".txt";
    private static final int RO_LENGTH = 20;
    protected AbstractOrigin<T, B> originRo;
    protected AbstractOrigin<T, B> originRw;

    @BeforeEach
    public void beforeEach() throws IOException {
        this.setOriginRo((AbstractOrigin<T, B>)this.newOriginRo());
        this.setOriginRw((AbstractOrigin<T, B>)this.newOriginRw());
    }

    protected AbstractOrigin<T, B> getOriginRo() {
        return Objects.requireNonNull(this.originRo, "originRo");
    }

    protected AbstractOrigin<T, B> getOriginRw() {
        return Objects.requireNonNull(this.originRw, "originRw");
    }

    private boolean isValid(RandomAccessFile raf) throws IOException {
        return Objects.requireNonNull(raf).getFD().valid();
    }

    protected abstract B newOriginRo() throws IOException;

    protected abstract B newOriginRw() throws IOException;

    protected void setOriginRo(AbstractOrigin<T, B> origin) {
        this.originRo = origin;
    }

    protected void setOriginRw(AbstractOrigin<T, B> origin) {
        this.originRw = origin;
    }

    @Test
    public void testGetByteArray() throws IOException {
        Assertions.assertArrayEquals((byte[])Files.readAllBytes(Paths.get(FILE_NAME_RO, new String[0])), (byte[])this.getOriginRo().getByteArray());
    }

    @Test
    public void testGetByteArrayAt_0_0() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.getOriginRo().getByteArray(0L, 0));
    }

    @Test
    public void testGetByteArrayAt_0_1() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[]{49}, (byte[])this.getOriginRo().getByteArray(0L, 1));
    }

    @Test
    public void testGetByteArrayAt_1_1() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[]{50}, (byte[])this.getOriginRo().getByteArray(1L, 1));
    }

    @Test
    public void testGetCharSequence() throws IOException {
        Assertions.assertNotNull((Object)this.getOriginRo().getCharSequence(Charset.defaultCharset()));
    }

    @Test
    public void testGetFile() throws IOException {
        this.testGetFile(this.getOriginRo().getFile(), 20L);
        FileUtils.touch(this.getOriginRw().getFile());
        this.testGetFile(this.getOriginRw().getFile(), 0L);
    }

    private void testGetFile(File file, long expectedLen) throws IOException {
        Assertions.assertNotNull((Object)file);
        Assertions.assertTrue((boolean)file.exists(), () -> "File does not exist: " + file);
        int length = FileUtils.readFileToByteArray(file).length;
        Assertions.assertEquals((long)length, (long)expectedLen, () -> String.format("File %s, actual length=%,d", file, length));
    }

    @Test
    public void testGetInputStream() throws IOException {
        try (InputStream inputStream = this.getOriginRo().getInputStream(new OpenOption[0]);){
            Assertions.assertNotNull((Object)inputStream);
        }
    }

    @Test
    public void testGetOutputStream() throws IOException {
        try (OutputStream output = this.getOriginRw().getOutputStream(new OpenOption[0]);){
            Assertions.assertNotNull((Object)output);
        }
    }

    @Test
    public void testGetPath() throws IOException {
        this.testGetPath(this.getOriginRo().getPath(), 20L);
        FileUtils.touch(this.getOriginRw().getPath().toFile());
        this.testGetPath(this.getOriginRw().getPath(), 0L);
    }

    private void testGetPath(Path path, long expectedLen) throws IOException {
        Assertions.assertNotNull((Object)path);
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        int length = Files.readAllBytes(path).length;
        Assertions.assertEquals((long)length, (long)expectedLen, () -> String.format("Path %s, actual length=%,d", path, length));
    }

    @Test
    public void testGetRandomAccessFile() throws IOException {
        try (RandomAccessFile raf = this.getOriginRo().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertTrue((boolean)this.isValid(raf));
        }
        boolean isRafOriginRo = this.getOriginRo() instanceof AbstractOrigin.RandomAccessFileOrigin;
        boolean isRafOriginRw = this.getOriginRw() instanceof AbstractOrigin.RandomAccessFileOrigin;
        try (RandomAccessFile raf = this.getOriginRo().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOriginRo && this.isValid(raf) ? 1 : 0) != 0);
        }
        raf = this.getOriginRo().getRandomAccessFile(StandardOpenOption.READ);
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOriginRo && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = this.getOriginRw().getRandomAccessFile(StandardOpenOption.WRITE);
        try {
            Assertions.assertNotNull((Object)raf);
            if (isRafOriginRw || this.getOriginRw().getFile() != null) {
                Assertions.assertTrue((boolean)this.isValid(raf), () -> this.getOriginRw().toString());
            } else {
                Assertions.assertFalse((boolean)this.isValid(raf), () -> this.getOriginRw().toString());
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = this.getOriginRw().getRandomAccessFile(StandardOpenOption.READ, StandardOpenOption.WRITE);
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOriginRw && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=StandardOpenOption.class)
    public void testGetRandomAccessFile(OpenOption openOption) throws IOException {
        try (RandomAccessFile raf = this.getOriginRw().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertTrue((boolean)this.isValid(raf));
        }
        boolean isRafOrigin = this.getOriginRw() instanceof AbstractOrigin.RandomAccessFileOrigin;
        try (RandomAccessFile raf = this.getOriginRw().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOrigin && this.isValid(raf) ? 1 : 0) != 0);
        }
        raf = this.getOriginRw().getRandomAccessFile(openOption);
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOrigin && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = this.getOriginRw().getRandomAccessFile(openOption);
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOrigin && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    @Test
    public void testGetReader() throws IOException {
        try (Reader reader = this.getOriginRo().getReader(Charset.defaultCharset());){
            Assertions.assertNotNull((Object)reader);
        }
    }

    @Test
    public void testGetWriter() throws IOException {
        try (Writer writer = this.getOriginRw().getWriter(Charset.defaultCharset(), new OpenOption[0]);){
            Assertions.assertNotNull((Object)writer);
        }
    }

    @Test
    public void testSize() throws IOException {
        Assertions.assertEquals((long)Files.size(Paths.get(FILE_NAME_RO, new String[0])), (long)this.getOriginRo().getByteArray().length);
    }
}

