/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.ComparatorAbstractTest;
import org.apache.commons.io.comparator.CompositeFileComparator;
import org.apache.commons.io.comparator.ExtensionFileComparator;
import org.apache.commons.io.comparator.ReverseFileComparator;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CompositeFileComparatorTest
extends ComparatorAbstractTest {
    @BeforeEach
    public void setUp() throws Exception {
        this.comparator = new CompositeFileComparator(SizeFileComparator.SIZE_COMPARATOR, ExtensionFileComparator.EXTENSION_COMPARATOR);
        this.reverse = new ReverseFileComparator(this.comparator);
        this.lessFile = new File(this.dir, "xyz.txt");
        this.equalFile1 = new File(this.dir, "foo.txt");
        this.equalFile2 = new File(this.dir, "bar.txt");
        this.moreFile = new File(this.dir, "foo.xyz");
        if (!this.lessFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.lessFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(Files.newOutputStream(this.lessFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output3, 32L);
        }
        if (!this.equalFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.equalFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(this.equalFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output2, 48L);
        }
        if (!this.equalFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.equalFile2 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.equalFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 48L);
        }
        if (!this.moreFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.moreFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.moreFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 48L);
        }
    }

    @Test
    public void testConstructorArray_Null() {
        CompositeFileComparator c = new CompositeFileComparator((Comparator[])null);
        Assertions.assertEquals((int)0, (int)c.compare(this.lessFile, this.moreFile), (String)"less,more");
        Assertions.assertEquals((int)0, (int)c.compare(this.moreFile, this.lessFile), (String)"more,less");
        Assertions.assertEquals((Object)"CompositeFileComparator{}", (Object)((Object)c).toString(), (String)"toString");
    }

    @Test
    public void testConstructorIterable_Null() {
        CompositeFileComparator c = new CompositeFileComparator((Iterable<Comparator<File>>)null);
        Assertions.assertEquals((int)0, (int)c.compare(this.lessFile, this.moreFile), (String)"less,more");
        Assertions.assertEquals((int)0, (int)c.compare(this.moreFile, this.lessFile), (String)"more,less");
        Assertions.assertEquals((Object)"CompositeFileComparator{}", (Object)((Object)c).toString(), (String)"toString");
    }

    @Test
    public void testConstructorIterable_order() {
        ArrayList<Comparator<File>> list = new ArrayList<Comparator<File>>();
        list.add(SizeFileComparator.SIZE_COMPARATOR);
        list.add(ExtensionFileComparator.EXTENSION_COMPARATOR);
        CompositeFileComparator c = new CompositeFileComparator(list);
        Assertions.assertEquals((int)0, (int)c.compare(this.equalFile1, this.equalFile2), (String)"equal");
        Assertions.assertTrue((c.compare(this.lessFile, this.moreFile) < 0 ? 1 : 0) != 0, (String)"less");
        Assertions.assertTrue((c.compare(this.moreFile, this.lessFile) > 0 ? 1 : 0) != 0, (String)"more");
    }
}

