/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.apache.commons.io.file.TestArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CountingPathVisitorTest
extends TestArguments {
    private void checkZeroCounts(CountingPathVisitor visitor) {
        Assertions.assertEquals((Object)CountingPathVisitor.withLongCounters(), (Object)visitor);
        Assertions.assertEquals((Object)CountingPathVisitor.withBigIntegerCounters(), (Object)visitor);
    }

    @ParameterizedTest
    @MethodSource(value={"countingPathVisitors"})
    public void testCountEmptyFolder(CountingPathVisitor visitor) throws IOException {
        this.checkZeroCounts(visitor);
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            CounterAssertions.assertCounts(1L, 0L, 0L, PathUtils.visitFileTree(visitor, tempDir.get()));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"countingPathVisitors"})
    public void testCountFolders1FileSize0(CountingPathVisitor visitor) throws IOException {
        this.checkZeroCounts(visitor);
        CounterAssertions.assertCounts(1L, 1L, 0L, PathUtils.visitFileTree(visitor, "src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]));
    }

    @ParameterizedTest
    @MethodSource(value={"countingPathVisitors"})
    public void testCountFolders1FileSize1(CountingPathVisitor visitor) throws IOException {
        this.checkZeroCounts(visitor);
        CounterAssertions.assertCounts(1L, 1L, 1L, PathUtils.visitFileTree(visitor, "src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]));
    }

    @ParameterizedTest
    @MethodSource(value={"countingPathVisitors"})
    public void testCountFolders2FileSize2(CountingPathVisitor visitor) throws IOException {
        this.checkZeroCounts(visitor);
        CounterAssertions.assertCounts(3L, 2L, 2L, PathUtils.visitFileTree(visitor, "src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]));
    }

    @ParameterizedTest
    @MethodSource(value={"countingPathVisitors"})
    void testToString(CountingPathVisitor visitor) {
        visitor.toString();
    }
}

