/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.junit.jupiter.api.Test;

public class PathUtilsCountingTest {
    @Test
    public void testCountEmptyFolder() throws IOException {
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            Counters.PathCounters pathCounts = PathUtils.countDirectory(tempDir.get());
            CounterAssertions.assertCounts(1L, 0L, 0L, pathCounts);
        }
    }

    @Test
    public void testCountFolders1FileSize0() throws IOException {
        Counters.PathCounters pathCounts = PathUtils.countDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]));
        CounterAssertions.assertCounts(1L, 1L, 0L, pathCounts);
    }

    @Test
    public void testCountFolders1FileSize1() throws IOException {
        Counters.PathCounters visitor = PathUtils.countDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]));
        CounterAssertions.assertCounts(1L, 1L, 1L, visitor);
    }

    @Test
    public void testCountFolders2FileSize2() throws IOException {
        Counters.PathCounters pathCounts = PathUtils.countDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]));
        CounterAssertions.assertCounts(3L, 2L, 2L, pathCounts);
    }

    @Test
    public void testCountFolders2FileSize4() throws IOException {
        Counters.PathCounters pathCounts = PathUtils.countDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-4", new String[0]));
        CounterAssertions.assertCounts(3L, 4L, 8L, pathCounts);
    }
}

