/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.junit.jupiter.api.Test;

public class PathUtilsDeleteTest
extends AbstractTempDirTest {
    @Test
    public void testDeleteDirectory1FileSize0() throws IOException {
        String fileName = "file-size-0.bin";
        FileUtils.copyFileToDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]).toFile(), this.tempDirPath.toFile());
        CounterAssertions.assertCounts(0L, 1L, 0L, PathUtils.delete(this.tempDirPath.resolve("file-size-0.bin")));
        Files.deleteIfExists(this.tempDirPath);
    }

    private void testDeleteDirectory1FileSize0(DeleteOption ... options) throws IOException {
        String fileName = "file-size-0.bin";
        FileUtils.copyFileToDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]).toFile(), this.tempDirPath.toFile());
        CounterAssertions.assertCounts(0L, 1L, 0L, PathUtils.delete(this.tempDirPath.resolve("file-size-0.bin"), options));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteDirectory1FileSize0ForceOff() throws IOException {
        this.testDeleteDirectory1FileSize0();
    }

    @Test
    public void testDeleteDirectory1FileSize0ForceOn() throws IOException {
        this.testDeleteDirectory1FileSize0();
    }

    @Test
    public void testDeleteDirectory1FileSize0NoOption() throws IOException {
        this.testDeleteDirectory1FileSize0(PathUtils.EMPTY_DELETE_OPTION_ARRAY);
    }

    @Test
    public void testDeleteDirectory1FileSize0OverrideReadonly() throws IOException {
        this.testDeleteDirectory1FileSize0(StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    @Test
    public void testDeleteDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        FileUtils.copyFileToDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]).toFile(), this.tempDirPath.toFile());
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.delete(this.tempDirPath.resolve("file-size-1.bin")));
        Files.deleteIfExists(this.tempDirPath);
    }

    private void testDeleteDirectory1FileSize1(DeleteOption ... options) throws IOException {
        String fileName = "file-size-1.bin";
        FileUtils.copyFileToDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]).toFile(), this.tempDirPath.toFile());
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.delete(this.tempDirPath.resolve("file-size-1.bin"), options));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteDirectory1FileSize1ForceOff() throws IOException {
        this.testDeleteDirectory1FileSize1();
    }

    @Test
    public void testDeleteDirectory1FileSize1ForceOn() throws IOException {
        this.testDeleteDirectory1FileSize1();
    }

    @Test
    public void testDeleteDirectory1FileSize1NoOption() throws IOException {
        this.testDeleteDirectory1FileSize1(PathUtils.EMPTY_DELETE_OPTION_ARRAY);
    }

    @Test
    public void testDeleteDirectory1FileSize1OverrideReadOnly() throws IOException {
        this.testDeleteDirectory1FileSize1(StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        this.testDeleteEmptyDirectory(PathUtils.delete(this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    private void testDeleteEmptyDirectory(DeleteOption ... options) throws IOException {
        this.testDeleteEmptyDirectory(PathUtils.delete(this.tempDirPath, options));
        Files.deleteIfExists(this.tempDirPath);
    }

    private void testDeleteEmptyDirectory(Counters.PathCounters pathCounts) {
        CounterAssertions.assertCounts(1L, 0L, 0L, pathCounts);
    }

    @Test
    public void testDeleteEmptyDirectoryForceOff() throws IOException {
        this.testDeleteEmptyDirectory();
    }

    @Test
    public void testDeleteEmptyDirectoryForceOn() throws IOException {
        this.testDeleteEmptyDirectory();
    }

    @Test
    public void testDeleteEmptyDirectoryNoOption() throws IOException {
        this.testDeleteEmptyDirectory(PathUtils.EMPTY_DELETE_OPTION_ARRAY);
    }

    @Test
    public void testDeleteEmptyDirectoryOverrideReadOnly() throws IOException {
        this.testDeleteEmptyDirectory(StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    @Test
    public void testDeleteFileDoesNotExist() throws IOException {
        CounterAssertions.assertCounts(0L, 0L, 0L, PathUtils.deleteFile(this.tempDirPath.resolve("file-does-not-exist.bin")));
        Files.deleteIfExists(this.tempDirPath);
    }
}

