/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;

public class AbstractFilterTest {
    static final String SVN_DIR_NAME = ".svn";
    static final boolean WINDOWS = File.separatorChar == '\\';
    @TempDir
    public File temporaryFolder;

    void assertFiltering(IOFileFilter filter, File file, boolean expected) throws IOException {
        Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        if (file != null && file.getParentFile() != null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file));
            Path path = file.toPath();
            Assertions.assertEquals((Object)expected, (Object)(filter.accept(path, null) != FileVisitResult.TERMINATE ? 1 : 0), filter::toString);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                Assertions.assertEquals((Object)expected, (Object)(filter.accept(path, Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0])) != FileVisitResult.TERMINATE ? 1 : 0), filter::toString);
            }
            Assertions.assertEquals((Object)expected, (Object)filter.matches(path), filter::toString);
        } else if (file == null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(null), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"));
            Assertions.assertEquals((Object)expected, (Object)filter.matches(null), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"));
        }
        Assertions.assertNotNull((Object)filter.toString());
    }

    void assertFiltering(IOFileFilter filter, Path path, boolean expected) {
        FileVisitResult expectedFileVisitResult = AbstractFileFilter.toDefaultFileVisitResult(expected);
        Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        if (path != null && path.getParent() != null) {
            Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
            Assertions.assertEquals((Object)(expectedFileVisitResult != FileVisitResult.TERMINATE ? 1 : 0), (Object)filter.matches(path), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        } else if (path == null) {
            Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for null"));
            Assertions.assertEquals((Object)(expectedFileVisitResult != FileVisitResult.TERMINATE ? 1 : 0), (Object)filter.matches(path), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for null"));
        }
        Assertions.assertNotNull((Object)filter.toString());
    }

    void assertFooBarFileFiltering(IOFileFilter filter) throws IOException {
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("bar"), true);
        this.assertFiltering(filter, new File("fred"), false);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("bar").toPath(), true);
        this.assertFiltering(filter, new File("fred").toPath(), false);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, IOCase.SENSITIVE);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("bar"), true);
        this.assertFiltering(filter, new File("FOO"), false);
        this.assertFiltering(filter, new File("BAR"), false);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("bar").toPath(), true);
        this.assertFiltering(filter, new File("FOO").toPath(), false);
        this.assertFiltering(filter, new File("BAR").toPath(), false);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, IOCase.INSENSITIVE);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("bar"), true);
        this.assertFiltering(filter, new File("FOO"), true);
        this.assertFiltering(filter, new File("BAR"), true);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("bar").toPath(), true);
        this.assertFiltering(filter, new File("FOO").toPath(), true);
        this.assertFiltering(filter, new File("BAR").toPath(), true);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, IOCase.SYSTEM);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("bar"), true);
        this.assertFiltering(filter, new File("FOO"), WINDOWS);
        this.assertFiltering(filter, new File("BAR"), WINDOWS);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("bar").toPath(), true);
        this.assertFiltering(filter, new File("FOO").toPath(), WINDOWS);
        this.assertFiltering(filter, new File("BAR").toPath(), WINDOWS);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, null);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("bar"), true);
        this.assertFiltering(filter, new File("FOO"), false);
        this.assertFiltering(filter, new File("BAR"), false);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("bar").toPath(), true);
        this.assertFiltering(filter, new File("FOO").toPath(), false);
        this.assertFiltering(filter, new File("BAR").toPath(), false);
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        filter = new NameFileFilter(list);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("bar"), true);
        this.assertFiltering(filter, new File("fred"), false);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("bar").toPath(), true);
        this.assertFiltering(filter, new File("fred").toPath(), false);
        filter = new NameFileFilter("foo");
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("FOO"), false);
        this.assertFiltering(filter, new File("barfoo"), false);
        this.assertFiltering(filter, new File("foobar"), false);
        this.assertFiltering(filter, new File("fred"), false);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("FOO").toPath(), false);
        this.assertFiltering(filter, new File("barfoo").toPath(), false);
        this.assertFiltering(filter, new File("foobar").toPath(), false);
        this.assertFiltering(filter, new File("fred").toPath(), false);
        filter = FileFilterUtils.nameFileFilter("foo", IOCase.INSENSITIVE);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, new File("FOO"), true);
        this.assertFiltering(filter, new File("barfoo"), false);
        this.assertFiltering(filter, new File("foobar"), false);
        this.assertFiltering(filter, new File("fred"), false);
        this.assertFiltering(filter, new File("foo").toPath(), true);
        this.assertFiltering(filter, new File("FOO").toPath(), true);
        this.assertFiltering(filter, new File("barfoo").toPath(), false);
        this.assertFiltering(filter, new File("foobar").toPath(), false);
        this.assertFiltering(filter, new File("fred").toPath(), false);
    }

    boolean equalsLastModified(File left, File right) throws IOException {
        return Files.getLastModifiedTime(left.toPath(), new LinkOption[0]).equals(Files.getLastModifiedTime(right.toPath(), new LinkOption[0]));
    }
}

