/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SymbolicLinkFileFilterTest {
    public static final String TARGET_SHORT_NAME = "SLFF_Target";
    public static final String TARGET_EXT = ".txt";
    public static final String TARGET_NAME = "SLFF_Target.txt";
    public static final String DIRECTORY_NAME = "SLFF_TargetDirectory";
    public static final String DIRECTORY_LINK_NAME = "SLFF_LinkDirectory";
    public static final String MISSING = "Missing";
    private static File testTargetFile;
    private static Path testTargetPath;
    private static File parentDirectoryFile;
    private static File testLinkFile;
    private static String linkName;
    private static Path testLinkPath;
    private static File targetDirFile;
    private static Path targetDirPath;
    private static Path testLinkDirPath;
    private static File testLinkDirFile;
    private static File missingFileFile;
    private static Path missingFilePath;
    private static SymbolicLinkFileFilter filter;

    private static SymbolicLinkFileFilter createMockFilter() {
        return new SymbolicLinkFileFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            boolean isSymbolicLink(Path filePath) {
                return filePath.toFile().exists() && filePath.toString().contains("Link");
            }
        };
    }

    private static Path createMockSymbolicLink(Path link, Path target) throws IOException {
        return Files.createFile(link, new FileAttribute[0]);
    }

    private static Path createRealSymbolicLink(Path link, Path target) throws IOException {
        Files.deleteIfExists(link);
        return Files.createSymbolicLink(link, target, new FileAttribute[0]);
    }

    @AfterAll
    static void tearDown() {
        testLinkDirFile.delete();
        targetDirFile.delete();
        testLinkFile.delete();
        testTargetFile.delete();
    }

    @BeforeAll
    static void testSetup() throws IOException {
        IOBiFunction<Path, Path, Path> symbolicLinkCreator;
        if (SystemUtils.IS_OS_WINDOWS) {
            symbolicLinkCreator = SymbolicLinkFileFilterTest::createMockSymbolicLink;
            filter = SymbolicLinkFileFilterTest.createMockFilter();
        } else {
            symbolicLinkCreator = SymbolicLinkFileFilterTest::createRealSymbolicLink;
            filter = SymbolicLinkFileFilter.INSTANCE;
        }
        testTargetFile = File.createTempFile(TARGET_SHORT_NAME, TARGET_EXT);
        testTargetPath = testTargetFile.toPath();
        parentDirectoryFile = testTargetFile.getParentFile();
        Path parentDirectoryPath = parentDirectoryFile.toPath();
        linkName = "SLFF_LinkTo" + testTargetFile.getName();
        testLinkPath = symbolicLinkCreator.apply(parentDirectoryPath.resolve(linkName), testTargetPath);
        testLinkFile = testLinkPath.toFile();
        targetDirPath = Files.createDirectories(parentDirectoryPath.resolve(DIRECTORY_NAME), new FileAttribute[0]);
        targetDirFile = targetDirPath.toFile();
        testLinkDirPath = symbolicLinkCreator.apply(parentDirectoryPath.resolve(DIRECTORY_LINK_NAME), targetDirPath);
        testLinkDirFile = testLinkDirPath.toFile();
        missingFileFile = new File(parentDirectoryPath.toFile(), MISSING);
        missingFilePath = missingFileFile.toPath();
    }

    @Test
    public void testFileFilter_HardDirectory() {
        Assertions.assertFalse((boolean)filter.accept(targetDirFile));
    }

    @Test
    public void testFileFilter_HardFile() {
        Assertions.assertFalse((boolean)filter.accept(testTargetFile));
    }

    @Test
    public void testFileFilter_Link() {
        Assertions.assertTrue((boolean)filter.accept(testLinkFile));
    }

    @Test
    public void testFileFilter_missingFile() {
        Assertions.assertFalse((boolean)filter.accept(missingFileFile));
    }

    @Test
    public void testFileFilter_PathLink() {
        Assertions.assertTrue((boolean)filter.accept(testLinkDirFile));
    }

    @Test
    public void testFileNameFilter_HardDirectory() {
        Assertions.assertFalse((boolean)filter.accept(parentDirectoryFile, DIRECTORY_NAME));
    }

    @Test
    public void testFileNameFilter_HardFile() {
        Assertions.assertFalse((boolean)filter.accept(parentDirectoryFile, TARGET_NAME));
    }

    @Test
    public void testFileNameFilter_Link() {
        Assertions.assertTrue((boolean)filter.accept(parentDirectoryFile, linkName));
    }

    @Test
    public void testFileNameFilter_missingFile() {
        Assertions.assertFalse((boolean)filter.accept(parentDirectoryFile, MISSING));
    }

    @Test
    public void testFileNameFilter_PathLink() {
        Assertions.assertTrue((boolean)filter.accept(parentDirectoryFile, DIRECTORY_LINK_NAME));
    }

    @Test
    public void testPathFilter_HardDirectory() {
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)filter.accept(targetDirPath, null)));
        Assertions.assertFalse((boolean)filter.matches(targetDirPath));
    }

    @Test
    public void testPathFilter_HardFile() {
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)filter.accept(testTargetPath, null)));
        Assertions.assertFalse((boolean)filter.matches(testTargetPath));
    }

    @Test
    public void testPathFilter_Link() {
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)filter.accept(testLinkPath, null)));
        Assertions.assertTrue((boolean)filter.matches(testLinkPath));
    }

    @Test
    public void testPathFilter_missingFile() {
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)filter.accept(missingFilePath, null)));
        Assertions.assertFalse((boolean)filter.matches(missingFilePath));
    }

    @Test
    public void testPathFilter_PathLink() {
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)filter.accept(testLinkDirPath, null)));
        Assertions.assertTrue((boolean)filter.matches(testLinkDirPath));
    }

    @Test
    public void testSymbolicLinkFileFilter() {
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)SymbolicLinkFileFilter.INSTANCE.accept(PathUtils.current(), null)));
        Assertions.assertFalse((boolean)filter.matches(PathUtils.current()));
    }
}

