/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFilterTest;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WildcardFileFilterTest
extends AbstractFilterTest {
    @Test
    public void testWildcard() throws IOException {
        WildcardFileFilter filter = new WildcardFileFilter("*.txt");
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT").toPath(), false);
        filter = new WildcardFileFilter("*.txt", IOCase.SENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        filter = WildcardFileFilter.builder().setWildcards("*.txt").setIoCase(IOCase.SENSITIVE).get();
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT").toPath(), false);
        filter = WildcardFileFilter.builder().setWildcards("*.txt").setIoCase(IOCase.INSENSITIVE).get();
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT").toPath(), true);
        filter = WildcardFileFilter.builder().setWildcards("*.txt").setIoCase(IOCase.SYSTEM).get();
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), WINDOWS);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT").toPath(), WINDOWS);
        filter = WildcardFileFilter.builder().setWildcards("*.txt").setIoCase(null).get();
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT").toPath(), false);
        filter = new WildcardFileFilter("*.java", "*.class");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp").toPath(), false);
        filter = WildcardFileFilter.builder().setWildcards("*.java", "*.class").get();
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp").toPath(), false);
        filter = WildcardFileFilter.builder().setWildcards("*.java", "*.class").setIoCase(IOCase.SENSITIVE).get();
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA").toPath(), false);
        filter = WildcardFileFilter.builder().setWildcards("*.java", "*.class").setIoCase(IOCase.INSENSITIVE).get();
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA").toPath(), true);
        filter = WildcardFileFilter.builder().setWildcards("*.java", "*.class").setIoCase(IOCase.SYSTEM).get();
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), WINDOWS);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA").toPath(), WINDOWS);
        filter = WildcardFileFilter.builder().setWildcards("*.java", "*.class").setIoCase(null).get();
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA").toPath(), false);
        List<String> patternList = Arrays.asList("*.txt", "*.xml", "*.gif");
        WildcardFileFilter listFilter = WildcardFileFilter.builder().setWildcards(patternList).get();
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.txt"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.xml"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.gif"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.bmp"), false);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.txt").toPath(), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.xml").toPath(), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.gif").toPath(), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.bmp").toPath(), false);
        File txtFile = new File("test.txt");
        Path txtPath = txtFile.toPath();
        File bmpFile = new File("test.bmp");
        Path bmpPath = bmpFile.toPath();
        File dirFile = new File("src/java");
        Path dirPath = dirFile.toPath();
        Assertions.assertTrue((boolean)listFilter.accept(txtFile));
        Assertions.assertFalse((boolean)listFilter.accept(bmpFile));
        Assertions.assertFalse((boolean)listFilter.accept(dirFile));
        Assertions.assertTrue((boolean)listFilter.matches(txtPath));
        Assertions.assertFalse((boolean)listFilter.matches(bmpPath));
        Assertions.assertFalse((boolean)listFilter.matches(dirPath));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)listFilter.accept(txtPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(bmpPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(dirPath, null)));
        Assertions.assertTrue((boolean)listFilter.accept(txtFile.getParentFile(), txtFile.getName()));
        Assertions.assertFalse((boolean)listFilter.accept(bmpFile.getParentFile(), bmpFile.getName()));
        Assertions.assertFalse((boolean)listFilter.accept(dirFile.getParentFile(), dirFile.getName()));
        Assertions.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)listFilter.accept(txtPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(bmpPath, null)));
        Assertions.assertEquals((Object)((Object)FileVisitResult.TERMINATE), (Object)((Object)listFilter.accept(dirPath, null)));
        Assertions.assertThrows(NullPointerException.class, () -> new WildcardFileFilter((String)null));
        Assertions.assertThrows(NullPointerException.class, () -> new WildcardFileFilter((String[])null));
        Assertions.assertThrows(NullPointerException.class, () -> new WildcardFileFilter((List<String>)null));
    }
}

