/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOBiConsumerTest {
    @Test
    public void testAccept() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOBiConsumer<String, Integer> biConsumer = (s2, i) -> ref.set(s2 + i);
        biConsumer.accept("A", 1);
        Assertions.assertEquals((Object)"A1", ref.get());
    }

    @Test
    public void testAndThen() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOBiConsumer<String, Integer> biConsumer1 = (s2, i) -> ref.set(s2 + i);
        IOBiConsumer<String, Integer> biConsumer2 = (s2, i) -> ref.set((String)ref.get() + i + s2);
        biConsumer1.andThen(biConsumer2).accept("B", 2);
        Assertions.assertEquals((Object)"B22B", ref.get());
    }

    @Test
    public void testAsBiConsumer() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        Assertions.assertThrows(UncheckedIOException.class, () -> map.forEach(TestConstants.THROWING_IO_BI_CONSUMER.asBiConsumer()));
        AtomicReference ref = new AtomicReference();
        IOBiConsumer<String, Integer> consumer1 = (t2, u) -> ref.set(t2 + u);
        map.forEach(consumer1.asBiConsumer());
        Assertions.assertEquals((Object)"a1", ref.get());
    }

    @Test
    public void testNoopIOConsumer() throws IOException {
        IOBiConsumer.noop().accept(null, null);
    }
}

