/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.TestUtils;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.test.ThrowOnCloseReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOConsumerTest {
    @Test
    void testAccept() throws IOException {
        IOConsumer.noop().accept(null);
        IOConsumer.noop().accept(".");
        Uncheck.accept(Files::size, PathUtils.current());
        AtomicReference ref = new AtomicReference();
        IOConsumer<String> consumer = s2 -> ref.set(s2 + "1");
        consumer.accept("A");
        Assertions.assertEquals((Object)"A1", ref.get());
    }

    @Test
    void testAndThen() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOConsumer<String> consumer1 = s2 -> ref.set(s2 + "1");
        IOConsumer<String> consumer2 = s2 -> ref.set((String)ref.get() + "2" + s2);
        consumer1.andThen(consumer2).accept("B");
        Assertions.assertEquals((Object)"B12B", ref.get());
    }

    @Test
    public void testAsConsumer() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Optional.of("a").ifPresent(TestUtils.throwingIOConsumer().asConsumer()));
        AtomicReference ref = new AtomicReference();
        IOConsumer<String> consumer1 = s2 -> ref.set(s2 + "1");
        Optional.of("a").ifPresent(consumer1.asConsumer());
        Assertions.assertEquals((Object)"a1", ref.get());
    }

    @Test
    public void testForAllArrayOf1() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (String[])null);
        IOConsumer.forAll(null, (String[])null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), "1"));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer<String> consumer1 = s2 -> ref.set((String)ref.get() + s2);
        IOConsumer.forAll(consumer1, "1");
        Assertions.assertEquals((Object)"01", (Object)ref.get());
    }

    @Test
    public void testForAllArrayOf2() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (String[])null);
        IOConsumer.forAll(null, (String[])null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), "1", "2"));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer<String> consumer1 = s2 -> ref.set((String)ref.get() + s2);
        IOConsumer.forAll(consumer1, "1", "2");
        Assertions.assertEquals((Object)"012", (Object)ref.get());
    }

    @Test
    public void testForAllIterableOf1() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Iterable)null);
        IOConsumer.forAll(null, (Iterable)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1")));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer<String> consumer1 = s2 -> ref.set((String)ref.get() + s2);
        IOConsumer.forAll(consumer1, Arrays.asList("1"));
        Assertions.assertEquals((Object)"01", (Object)ref.get());
    }

    @Test
    public void testForAllIterableOf2() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Iterable)null);
        IOConsumer.forAll(null, (Iterable)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1", "2")));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer<String> consumer1 = s2 -> ref.set((String)ref.get() + s2);
        IOConsumer.forAll(consumer1, Arrays.asList("1", "2"));
        Assertions.assertEquals((Object)"012", (Object)ref.get());
    }

    @Test
    public void testForAllStreamOf1() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Stream)null);
        IOConsumer.forAll(null, (Stream)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1").stream()));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer<String> consumer1 = s2 -> ref.set((String)ref.get() + s2);
        IOConsumer.forAll(consumer1, Arrays.asList("1").stream());
        Assertions.assertEquals((Object)"01", (Object)ref.get());
    }

    @Test
    public void testForAllStreamOf2() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Stream)null);
        IOConsumer.forAll(null, (Stream)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1", "2").stream()));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer<String> consumer1 = s2 -> ref.set((String)ref.get() + s2);
        IOConsumer.forAll(consumer1, Arrays.asList("1", "2").stream());
        Assertions.assertEquals((Object)"012", (Object)ref.get());
    }

    @Test
    public void testNoop() {
        Closeable nullCloseable = null;
        IOConsumer noopConsumer = IOConsumer.noop();
        Assertions.assertDoesNotThrow(() -> IOUtils.close(nullCloseable, noopConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s"), noopConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new ThrowOnCloseReader(new StringReader("s")), noopConsumer));
    }
}

