/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOSpliterator;
import org.apache.commons.io.function.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOSpliteratorTest {
    private IOSpliterator<Path> spliterator;

    @BeforeEach
    public void beforeEach() {
        this.spliterator = IOSpliterator.adapt(this.newPathList().spliterator());
    }

    private List<Path> newPathList() {
        return Arrays.asList(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B);
    }

    @Test
    public void testAdapt() {
        this.spliterator = IOSpliterator.adapt(this.newPathList().spliterator());
        Assertions.assertEquals((long)2L, (long)this.spliterator.estimateSize());
    }

    @Test
    public void testAsSpliterator() {
        Assertions.assertEquals((long)2L, (long)this.spliterator.estimateSize());
        Assertions.assertEquals((long)2L, (long)this.spliterator.asSpliterator().estimateSize());
    }

    @Test
    public void testCharacteristics() {
        Assertions.assertEquals((int)this.spliterator.unwrap().characteristics(), (int)this.spliterator.characteristics());
        Assertions.assertEquals((int)this.spliterator.unwrap().characteristics(), (int)this.spliterator.asSpliterator().characteristics());
    }

    @Test
    public void testEstimateSize() {
        Assertions.assertEquals((long)2L, (long)this.spliterator.estimateSize());
        Assertions.assertEquals((long)this.spliterator.unwrap().estimateSize(), (long)this.spliterator.estimateSize());
        Assertions.assertEquals((long)this.spliterator.unwrap().estimateSize(), (long)this.spliterator.asSpliterator().estimateSize());
    }

    @Test
    public void testForEachRemaining() {
        ArrayList list = new ArrayList();
        this.spliterator.forEachRemaining(list::add);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals(this.newPathList(), list);
    }

    @Test
    public void testForEachRemainingAsSpliterator() {
        ArrayList list = new ArrayList();
        this.spliterator.asSpliterator().forEachRemaining(list::add);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals(this.newPathList(), list);
    }

    @Test
    public void testGetComparator() {
        if (this.spliterator.hasCharacteristics(4)) {
            Assertions.assertEquals(this.spliterator.unwrap().getComparator(), this.spliterator.getComparator());
            Assertions.assertEquals(this.spliterator.unwrap().getComparator(), this.spliterator.asSpliterator().getComparator());
        } else {
            Assertions.assertThrows(IllegalStateException.class, () -> this.spliterator.unwrap().getComparator());
            Assertions.assertThrows(IllegalStateException.class, () -> this.spliterator.asSpliterator().getComparator());
        }
        IOSpliterator adapted = IOSpliterator.adapt(new TreeSet<Path>(this.newPathList()).stream().sorted().spliterator());
        IOComparator comparator = adapted.getComparator();
        Assertions.assertNull(comparator);
    }

    @Test
    public void testGetExactSizeIfKnown() {
        Assertions.assertEquals((long)2L, (long)this.spliterator.getExactSizeIfKnown());
        Assertions.assertEquals((long)this.spliterator.unwrap().getExactSizeIfKnown(), (long)this.spliterator.getExactSizeIfKnown());
        Assertions.assertEquals((long)this.spliterator.unwrap().getExactSizeIfKnown(), (long)this.spliterator.asSpliterator().getExactSizeIfKnown());
    }

    @Test
    public void testHasCharacteristics() {
        Assertions.assertTrue((boolean)this.spliterator.hasCharacteristics(this.spliterator.characteristics()));
        Assertions.assertEquals((Object)this.spliterator.unwrap().hasCharacteristics(this.spliterator.unwrap().characteristics()), (Object)this.spliterator.hasCharacteristics(this.spliterator.characteristics()));
        Assertions.assertEquals((Object)this.spliterator.unwrap().hasCharacteristics(this.spliterator.unwrap().characteristics()), (Object)this.spliterator.asSpliterator().hasCharacteristics(this.spliterator.asSpliterator().characteristics()));
    }

    @Test
    public void testTryAdvance() {
        AtomicReference ref = new AtomicReference();
        Assertions.assertTrue((boolean)this.spliterator.tryAdvance(ref::set));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, ref.get());
    }

    @Test
    public void testTrySplit() {
        IOSpliterator<Path> trySplit = this.spliterator.trySplit();
        Assertions.assertNotNull(trySplit);
        Assertions.assertTrue((this.spliterator.getExactSizeIfKnown() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testUnwrap() {
        Assertions.assertNotNull(this.spliterator.unwrap());
    }
}

