/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReaderInputStreamTest {
    private static final String UTF_16 = StandardCharsets.UTF_16.name();
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;
    private final Random random = new Random();

    static Stream<Arguments> charsetData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Cp930", "\u0391"}), Arguments.of((Object[])new Object[]{"ISO_8859_1", "A"}), Arguments.of((Object[])new Object[]{UTF_8, "\u0391"}));
    }

    private ReaderInputStream createInputStream() throws IOException {
        return ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader(TEST_STRING))).setCharset(StandardCharsets.ISO_8859_1).get();
    }

    @Test
    public void testAvailableAfterClose() throws IOException {
        try (ReaderInputStream inputStream = this.createInputStream();){
            ((InputStream)inputStream).close();
            Assertions.assertEquals((int)0, (int)((InputStream)inputStream).available());
        }
    }

    @Test
    public void testAvailableAfterOpen() throws IOException {
        try (ReaderInputStream inputStream = this.createInputStream();){
            Assertions.assertEquals((int)0, (int)((InputStream)inputStream).available());
            ((InputStream)inputStream).read();
            Assertions.assertEquals((int)(TEST_STRING.length() - 1), (int)((InputStream)inputStream).available());
        }
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testBufferSmallest() throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader("\ud800"), charset, (int)ReaderInputStream.minBufferSize(charset.newEncoder()));){
            ((InputStream)in).read();
        }
        in = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("\ud800"))).setCharset(charset).setBufferSize((int)ReaderInputStream.minBufferSize(charset.newEncoder()))).get();
        try {
            ((InputStream)in).read();
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    @Test
    public void testBufferTooSmall() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ReaderInputStream((Reader)new StringReader("\ud800"), StandardCharsets.UTF_8, -1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ReaderInputStream((Reader)new StringReader("\ud800"), StandardCharsets.UTF_8, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ReaderInputStream((Reader)new StringReader("\ud800"), StandardCharsets.UTF_8, 1));
    }

    @ParameterizedTest
    @MethodSource(value={"charsetData"})
    public void testCharsetEncoderFlush(String charsetName, String data) throws IOException {
        Charset charset = Charset.forName(charsetName);
        byte[] expected = data.getBytes(charset);
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(data), charset);){
            Assertions.assertEquals((Object)Arrays.toString(expected), (Object)Arrays.toString(IOUtils.toByteArray(in)));
        }
        in = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader(data))).setCharset(charset).get();
        try {
            Assertions.assertEquals((Object)Arrays.toString(expected), (Object)Arrays.toString(IOUtils.toByteArray(in)));
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    @Test
    public void testCharsetMismatchInfiniteLoop() throws IOException {
        char[] inputChars = new char[]{'\u00e0', '\u00b2', '\u00a0'};
        Charset charset = StandardCharsets.US_ASCII;
        try (ReaderInputStream stream = new ReaderInputStream((Reader)new CharArrayReader(inputChars), charset);){
            IOUtils.toCharArray((InputStream)stream, charset);
        }
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testCodingError() throws IOException {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader("\ud800"), encoder);){
            Assertions.assertDoesNotThrow(() -> in.read());
        }
        encoder = StandardCharsets.UTF_8.newEncoder();
        in = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("\ud800"))).setCharsetEncoder(encoder).get();
        try {
            Assertions.assertDoesNotThrow(() -> in.read());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testCodingErrorAction() throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT);
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader("\ud800aa"), encoder, (int)ReaderInputStream.minBufferSize(encoder));){
            Assertions.assertThrows(CharacterCodingException.class, in::read);
        }
        in = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("\ud800aa"))).setCharsetEncoder(encoder).setBufferSize((int)ReaderInputStream.minBufferSize(charset.newEncoder()))).get();
        try {
            Assertions.assertThrows(CharacterCodingException.class, in::read);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testConstructNullCharset() throws IOException {
        Charset charset = Charset.defaultCharset();
        Charset encoder = null;
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader("ABC"), encoder, (int)ReaderInputStream.minBufferSize(charset.newEncoder()));){
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testConstructNullCharsetEncoder() throws IOException {
        Charset charset = Charset.defaultCharset();
        CharsetEncoder encoder = null;
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader("ABC"), encoder, (int)ReaderInputStream.minBufferSize(charset.newEncoder()));){
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
    }

    @Test
    @Timeout(value=500L, unit=TimeUnit.MILLISECONDS)
    public void testConstructNullCharsetNameEncoder() throws IOException {
        Charset charset = Charset.defaultCharset();
        String charsetName = null;
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader("ABC"), charsetName, (int)ReaderInputStream.minBufferSize(charset.newEncoder()));){
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
        in = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("ABC"))).setCharset(charsetName)).setBufferSize((int)ReaderInputStream.minBufferSize(charset.newEncoder()))).get();
        try {
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void testIo803SAXException() throws IOException {
        StringReader reader = new StringReader("");
        try (ReaderInputStream inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setCharset(StandardCharsets.UTF_8).setReader(reader)).get();){
            InputSource inputSource = new InputSource(inputStream);
            Assertions.assertThrows(SAXException.class, () -> DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource));
        }
    }

    @Test
    public void testIo803StringReaderSanityCheck() {
        StringReader reader = new StringReader("");
        InputSource inputSource = new InputSource(reader);
        Assertions.assertThrows(SAXException.class, () -> DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource));
    }

    @Test
    public void testLargeUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(LARGE_TEST_STRING, UTF_8);
    }

    @Test
    public void testLargeUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(LARGE_TEST_STRING, UTF_8);
    }

    @Test
    public void testReadAfterClose() throws IOException {
        try (ReaderInputStream inputStream = this.createInputStream();){
            ((InputStream)inputStream).close();
            Assertions.assertThrows(IOException.class, inputStream::read);
        }
    }

    @Test
    public void testReadEofTwice() throws IOException {
        try (ReaderInputStream reader = ((ReaderInputStream.Builder)ReaderInputStream.builder().setCharset(StandardCharsets.UTF_8).setReader(new StringReader("123"))).get();){
            Assertions.assertEquals((int)49, (int)reader.read());
            Assertions.assertEquals((int)50, (int)reader.read());
            Assertions.assertEquals((int)51, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testReadZero() throws Exception {
        String inStr = "test";
        try (ReaderInputStream inputStream = new ReaderInputStream(new StringReader("test"));){
            this.testReadZero("test", inputStream);
        }
        inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("test"))).get();
        try {
            this.testReadZero("test", inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void testReadZero(String inStr, ReaderInputStream inputStream) throws IOException {
        byte[] bytes = new byte[30];
        Assertions.assertEquals((int)0, (int)inputStream.read(bytes, 0, 0));
        Assertions.assertEquals((int)inStr.length(), (int)inputStream.read(bytes, 0, inStr.length() + 1));
        Assertions.assertEquals((int)0, (int)inputStream.read(bytes, 0, 0));
    }

    @Test
    public void testReadZeroEmptyString() throws Exception {
        try (ReaderInputStream inputStream = new ReaderInputStream(new StringReader(""));){
            byte[] bytes = new byte[30];
            Assertions.assertEquals((int)0, (int)inputStream.read(bytes, 0, 0));
            Assertions.assertEquals((int)-1, (int)inputStream.read(bytes, 0, 1));
            Assertions.assertEquals((int)0, (int)inputStream.read(bytes, 0, 0));
            Assertions.assertEquals((int)-1, (int)inputStream.read(bytes, 0, 1));
        }
    }

    @Test
    public void testResetCharset() {
        Assertions.assertNotNull((Object)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("\ud800"))).setCharset((Charset)null).getCharset());
    }

    @Test
    public void testResetCharsetEncoder() {
        Assertions.assertNotNull((Object)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("\ud800"))).setCharsetEncoder(null).getCharsetEncoder());
    }

    @Test
    public void testResetCharsetName() {
        Assertions.assertNotNull((Object)((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader("\ud800"))).setCharset((String)null)).getCharset());
    }

    @Test
    public void testUTF16WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, UTF_16);
    }

    @Test
    public void testUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(TEST_STRING, UTF_8);
    }

    @Test
    public void testUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, UTF_8);
    }

    private void testWithBufferedRead(byte[] expected, ReaderInputStream in) throws IOException {
        byte[] buffer = new byte[128];
        int offset = 0;
        block0: while (true) {
            int bufferLength;
            int bufferOffset;
            int read;
            if ((read = in.read(buffer, bufferOffset = this.random.nextInt(64), bufferLength = this.random.nextInt(64))) == -1) {
                Assertions.assertEquals((int)offset, (int)expected.length);
                break;
            }
            Assertions.assertTrue((read <= bufferLength ? 1 : 0) != 0);
            while (true) {
                if (read <= 0) continue block0;
                Assertions.assertTrue((offset < expected.length ? 1 : 0) != 0);
                Assertions.assertEquals((byte)expected[offset], (byte)buffer[bufferOffset]);
                ++offset;
                ++bufferOffset;
                --read;
            }
            break;
        }
    }

    private void testWithBufferedRead(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(testString), charsetName);){
            this.testWithBufferedRead(expected, in);
        }
        in = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(new StringReader(testString))).setCharset(charsetName)).get();
        try {
            this.testWithBufferedRead(expected, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void testWithSingleByteRead(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(testString), charsetName);){
            for (byte b : bytes) {
                int read = in.read();
                Assertions.assertTrue((read >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((read <= 255 ? 1 : 0) != 0);
                Assertions.assertEquals((byte)b, (byte)((byte)read));
            }
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

