/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.UncheckedFilterInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UncheckedFilterInputStreamTest {
    private UncheckedFilterInputStream stringInputStream;
    private UncheckedFilterInputStream brokenInputStream;
    private IOException exception = new IOException("test exception");

    @BeforeEach
    public void beforeEach() {
        this.stringInputStream = ((UncheckedFilterInputStream.Builder)UncheckedFilterInputStream.builder().setInputStream(new BufferedInputStream(((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("01")).get()))).get();
        this.exception = new IOException("test exception");
        this.brokenInputStream = ((UncheckedFilterInputStream.Builder)UncheckedFilterInputStream.builder().setInputStream(new BrokenInputStream(this.exception))).get();
    }

    @Test
    public void testClose() {
        this.stringInputStream.close();
        Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.read());
    }

    @Test
    public void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.close())).getCause());
    }

    @Test
    public void testMarkReset() {
        this.stringInputStream.mark(10);
        int c = this.stringInputStream.read();
        this.stringInputStream.reset();
        Assertions.assertEquals((int)c, (int)this.stringInputStream.read());
    }

    @Test
    public void testRead() {
        UncheckedFilterInputStream inputStream = this.stringInputStream;
        try (UncheckedFilterInputStream uncheckedReader = ((UncheckedFilterInputStream.Builder)UncheckedFilterInputStream.builder().setInputStream(inputStream)).get();){
            Assertions.assertEquals((int)48, (int)uncheckedReader.read());
            Assertions.assertEquals((int)49, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
        }
    }

    @Test
    public void testReadByteArray() {
        UncheckedFilterInputStream inputStream = this.stringInputStream;
        try (UncheckedFilterInputStream uncheckedReader = ((UncheckedFilterInputStream.Builder)UncheckedFilterInputStream.builder().setInputStream(inputStream)).get();){
            byte[] array = new byte[1];
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)48, (int)array[0]);
            array[0] = 0;
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)49, (int)array[0]);
            array[0] = 0;
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)0, (int)array[0]);
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)0, (int)array[0]);
        }
    }

    @Test
    public void testReadByteArrayIndexed() {
        UncheckedFilterInputStream inputStream = this.stringInputStream;
        try (UncheckedFilterInputStream uncheckedReader = ((UncheckedFilterInputStream.Builder)UncheckedFilterInputStream.builder().setInputStream(inputStream)).get();){
            byte[] array = new byte[1];
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)48, (int)array[0]);
            array[0] = 0;
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)49, (int)array[0]);
            array[0] = 0;
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)0, (int)array[0]);
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)0, (int)array[0]);
        }
    }

    @Test
    public void testReadByteArrayIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.read(new byte[1], 0, 1))).getCause());
    }

    @Test
    public void testReadByteArrayThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.read(new byte[1]))).getCause());
    }

    @Test
    public void testReadThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.read())).getCause());
    }

    @Test
    public void testResetThrows() {
        try (UncheckedFilterInputStream closedReader = ((UncheckedFilterInputStream.Builder)UncheckedFilterInputStream.builder().setInputStream(ClosedInputStream.INSTANCE)).get();){
            closedReader.close();
            Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.reset());
        }
    }

    @Test
    public void testSkip() {
        Assertions.assertEquals((long)1L, (long)this.stringInputStream.skip(1L));
    }

    @Test
    public void testSkipThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenInputStream.skip(1L))).getCause());
    }
}

