/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.serialization.AbstractCloseableListTest;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.MockSerializedClass;
import org.apache.commons.io.serialization.ObjectStreamClassPredicate;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatingObjectInputStreamTest
extends AbstractCloseableListTest {
    private static final ClassNameMatcher ALWAYS_TRUE = className -> true;
    private MockSerializedClass testObject;
    private InputStream testStream;

    private void assertSerialization(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        MockSerializedClass result = (MockSerializedClass)ois.readObject();
        Assertions.assertEquals((Object)this.testObject, (Object)result);
    }

    private ValidatingObjectInputStream.Builder newBuilder() {
        return (ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setInputStream(this.testStream);
    }

    private ValidatingObjectInputStream newFixture() throws IOException {
        return this.newBuilder().get();
    }

    @BeforeEach
    public void setupMockSerializedClass() throws IOException {
        this.testObject = new MockSerializedClass(UUID.randomUUID().toString());
        ByteArrayOutputStream bos = this.addCloseable(new ByteArrayOutputStream());
        ObjectOutputStream oos = this.addCloseable(new ObjectOutputStream(bos));
        oos.writeObject(this.testObject);
        this.testStream = this.addCloseable(new ByteArrayInputStream(bos.toByteArray()));
    }

    @Test
    public void testAcceptCustomMatcherBuilder() throws Exception {
        this.assertSerialization(this.addCloseable(this.newBuilder().accept(ALWAYS_TRUE).get()));
    }

    @Test
    public void testAcceptCustomMatcherInstance() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(ALWAYS_TRUE));
    }

    @Test
    public void testAcceptOneFail() throws Exception {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(Integer.class)));
    }

    @Test
    public void testAcceptOnePassBuilder() throws Exception {
        this.assertSerialization(this.addCloseable(this.newBuilder().accept(MockSerializedClass.class).get()));
    }

    @Test
    public void testAcceptOnePassInstance() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class));
    }

    @Test
    public void testAcceptPatternBuilder() throws Exception {
        this.assertSerialization(this.addCloseable(this.newBuilder().accept(Pattern.compile(".*MockSerializedClass.*")).get()));
    }

    @Test
    public void testAcceptPatternInstance() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(Pattern.compile(".*MockSerializedClass.*")));
    }

    @Test
    public void testAcceptWildcardBuilder() throws Exception {
        this.assertSerialization(this.addCloseable(this.newBuilder().accept("org.apache.commons.io.*").get()));
    }

    @Test
    public void testAcceptWildcardInstance() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept("org.apache.commons.io.*"));
    }

    @Test
    public void testBuildDefault() throws Exception {
        byte[] serialized = SerializationUtils.serialize((Serializable)((Object)""));
        ValidatingObjectInputStream is = ((ValidatingObjectInputStream.Builder)this.newBuilder().setInputStream(new ByteArrayInputStream(serialized))).get();
        if (is != null) {
            ((InputStream)is).close();
        }
    }

    @Test
    public void testConstructor() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(ALWAYS_TRUE));
    }

    @Test
    public void testCustomInvalidMethod() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            final class CustomVOIS
            extends ValidatingObjectInputStream {
                CustomVOIS(InputStream is) throws IOException {
                    super(is);
                }

                @Override
                protected void invalidClassNameFound(String className) throws InvalidClassException {
                    throw new RuntimeException("Custom exception");
                }
            }
            this.assertSerialization(this.addCloseable(new CustomVOIS(this.testStream)).reject(Integer.class));
        });
    }

    @Test
    public void testExceptionIncludesClassName() throws Exception {
        InvalidClassException ice = (InvalidClassException)Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture())));
        String name = MockSerializedClass.class.getName();
        Assertions.assertTrue((boolean)ice.getMessage().contains(name), (String)("Expecting message to contain " + name));
    }

    @Test
    public void testJavadocExample() throws Exception {
        byte[] byteArray;
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        map1.put("1", 1);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(map1);
            oos.flush();
            byteArray = baos.toByteArray();
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
             ValidatingObjectInputStream vois = ((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().accept(HashMap.class, Number.class, Integer.class).setInputStream(bais)).get();){
            HashMap map2 = (HashMap)vois.readObject();
            Assertions.assertEquals(map1, (Object)map2);
        }
        ObjectStreamClassPredicate predicate = new ObjectStreamClassPredicate().accept(HashMap.class, Number.class, Integer.class);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
             ValidatingObjectInputStream vois = ((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setPredicate(predicate).setInputStream(bais)).get();){
            HashMap map2 = (HashMap)vois.readObject();
            Assertions.assertEquals(map1, (Object)map2);
        }
    }

    @Test
    public void testNoAccept() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture())));
    }

    @Test
    public void testOurTestClassAcceptedFirst() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class, Integer.class));
    }

    @Test
    public void testOurTestClassAcceptedFirstWildcard() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept("*MockSerializedClass", "*Integer"));
    }

    @Test
    public void testOurTestClassAcceptedSecond() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(Integer.class, MockSerializedClass.class));
    }

    @Test
    public void testOurTestClassAcceptedSecondWildcard() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept("*Integer", "*MockSerializedClass"));
    }

    @Test
    public void testOurTestClassNotAccepted() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(Integer.class)));
    }

    @Test
    public void testOurTestClassOnlyAccepted() throws Exception {
        this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class));
    }

    @Test
    public void testRejectBuilder() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newBuilder().accept(Long.class).reject(MockSerializedClass.class, Integer.class).get())));
    }

    @Test
    public void testRejectCustomMatcherBuilder() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newBuilder().accept(MockSerializedClass.class).reject(ALWAYS_TRUE).get())));
    }

    @Test
    public void testRejectCustomMatcherInstance() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class).reject(ALWAYS_TRUE)));
    }

    @Test
    public void testRejectInstance() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(Long.class).reject(MockSerializedClass.class, Integer.class)));
    }

    @Test
    public void testRejectOnly() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).reject(Integer.class)));
    }

    @Test
    public void testRejectPattern() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class).reject(Pattern.compile("org.*"))));
    }

    @Test
    public void testRejectPrecedenceBuilder() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newBuilder().accept(MockSerializedClass.class).reject(MockSerializedClass.class, Integer.class).get())));
    }

    @Test
    public void testRejectPrecedenceInstance() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class).reject(MockSerializedClass.class, Integer.class)));
    }

    @Test
    public void testRejectWildcardBuilder() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newBuilder().accept(MockSerializedClass.class).reject("org.*").get())));
    }

    @Test
    public void testRejectWildcardInstance() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization(this.addCloseable(this.newFixture()).accept(MockSerializedClass.class).reject("org.*")));
    }

    @Test
    public void testReuseConfiguration() throws Exception {
        ValidatingObjectInputStream vois;
        ValidatingObjectInputStream vois2;
        byte[] byteArray;
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        map1.put("1", 1);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(map1);
            oos.flush();
            byteArray = baos.toByteArray();
        }
        ObjectStreamClassPredicate predicate = new ObjectStreamClassPredicate().accept(HashMap.class, Number.class, Integer.class);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);){
            vois2 = ((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setPredicate(predicate).setInputStream(bais)).get();
            try {
                Assertions.assertEquals(map1, vois2.readObjectCast());
            }
            finally {
                if (vois2 != null) {
                    vois2.close();
                }
            }
        }
        bais = new ByteArrayInputStream(byteArray);
        try {
            vois2 = ((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setPredicate(predicate).setInputStream(bais)).get();
            try {
                Assertions.assertEquals(map1, vois2.readObjectCast());
            }
            finally {
                if (vois2 != null) {
                    vois2.close();
                }
            }
        }
        finally {
            bais.close();
        }
        ValidatingObjectInputStream.Builder builder = ValidatingObjectInputStream.builder().setPredicate(predicate);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);){
            vois = ((ValidatingObjectInputStream.Builder)builder.setInputStream(bais)).get();
            try {
                Assertions.assertEquals(map1, vois.readObjectCast());
            }
            finally {
                if (vois != null) {
                    vois.close();
                }
            }
        }
        bais = new ByteArrayInputStream(byteArray);
        try {
            vois = ((ValidatingObjectInputStream.Builder)builder.setInputStream(bais)).get();
            try {
                Assertions.assertEquals(map1, vois.readObjectCast());
            }
            finally {
                if (vois != null) {
                    vois.close();
                }
            }
        }
        finally {
            bais.close();
        }
    }
}

