/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.dpx;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jcodec.common.StringUtils;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.IOUtils;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.containers.dpx.DPXMetadata;
import org.jcodec.containers.dpx.FileHeader;
import org.jcodec.containers.dpx.FilmHeader;
import org.jcodec.containers.dpx.ImageElement;
import org.jcodec.containers.dpx.ImageHeader;
import org.jcodec.containers.dpx.ImageSourceHeader;
import org.jcodec.containers.dpx.TelevisionHeader;

public class DPXReader {
    private static final int READ_BUFFER_SIZE = 3072;
    static final int IMAGEINFO_OFFSET = 768;
    static final int IMAGESOURCE_OFFSET = 1408;
    static final int FILM_OFFSET = 1664;
    static final int TVINFO_OFFSET = 1920;
    public static final int SDPX = 1396985944;
    private final ByteBuffer readBuf = ByteBuffer.allocate(3072);
    private final int magic;
    private boolean eof;

    public DPXReader(SeekableByteChannel ch) throws IOException {
        this.initialRead(ch);
        this.magic = this.readBuf.getInt();
        if (this.magic == 1396985944) {
            this.readBuf.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.readBuf.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public DPXMetadata parseMetadata() {
        DPXMetadata dpx = new DPXMetadata();
        dpx.file = DPXReader.readFileInfo(this.readBuf);
        dpx.file.magic = this.magic;
        this.readBuf.position(768);
        dpx.image = DPXReader.readImageInfoHeader(this.readBuf);
        this.readBuf.position(1408);
        dpx.imageSource = DPXReader.readImageSourceHeader(this.readBuf);
        this.readBuf.position(1664);
        dpx.film = DPXReader.readFilmInformationHeader(this.readBuf);
        this.readBuf.position(1920);
        dpx.television = DPXReader.readTelevisionInfoHeader(this.readBuf);
        dpx.userId = DPXReader.readNullTermString(this.readBuf, 32);
        return dpx;
    }

    private void initialRead(ReadableByteChannel ch) throws IOException {
        this.readBuf.clear();
        if (ch.read(this.readBuf) == -1) {
            this.eof = true;
        }
        this.readBuf.flip();
    }

    private static FileHeader readFileInfo(ByteBuffer bb) {
        FileHeader h2 = new FileHeader();
        h2.imageOffset = bb.getInt();
        h2.version = DPXReader.readNullTermString(bb, 8);
        h2.filesize = bb.getInt();
        h2.ditto = bb.getInt();
        h2.genericHeaderLength = bb.getInt();
        h2.industryHeaderLength = bb.getInt();
        h2.userHeaderLength = bb.getInt();
        h2.filename = DPXReader.readNullTermString(bb, 100);
        h2.created = DPXReader.tryParseISO8601Date(DPXReader.readNullTermString(bb, 24));
        h2.creator = DPXReader.readNullTermString(bb, 100);
        h2.projectName = DPXReader.readNullTermString(bb, 200);
        h2.copyright = DPXReader.readNullTermString(bb, 200);
        h2.encKey = bb.getInt();
        return h2;
    }

    static Date tryParseISO8601Date(String dateString) {
        if (StringUtils.isEmpty(dateString)) {
            return null;
        }
        String noTZ = "yyyy:MM:dd:HH:mm:ss";
        if (dateString.length() == noTZ.length()) {
            return DPXReader.date(dateString, noTZ);
        }
        if (dateString.length() == noTZ.length() + 4) {
            dateString = dateString + "00";
        }
        return DPXReader.date(dateString, "yyyy:MM:dd:HH:mm:ss:Z");
    }

    private static Date date(String dateString, String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.US);
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String readNullTermString(ByteBuffer bb, int length) {
        ByteBuffer b = ByteBuffer.allocate(length);
        bb.get(b.array(), 0, length);
        return NIOUtils.readNullTermString(b);
    }

    public static DPXReader readFile(File file) throws IOException {
        FileChannelWrapper _in = NIOUtils.readableChannel(file);
        try {
            DPXReader dPXReader = new DPXReader(_in);
            return dPXReader;
        }
        finally {
            IOUtils.closeQuietly(_in);
        }
    }

    private static TelevisionHeader readTelevisionInfoHeader(ByteBuffer r) {
        TelevisionHeader h2 = new TelevisionHeader();
        h2.timecode = r.getInt();
        h2.userBits = r.getInt();
        h2.interlace = r.get();
        h2.filedNumber = r.get();
        h2.videoSignalStarted = r.get();
        h2.zero = r.get();
        h2.horSamplingRateHz = r.getInt();
        h2.vertSampleRateHz = r.getInt();
        h2.frameRate = r.getInt();
        h2.timeOffset = r.getInt();
        h2.gamma = r.getInt();
        h2.blackLevel = r.getInt();
        h2.blackGain = r.getInt();
        h2.breakpoint = r.getInt();
        h2.referenceWhiteLevel = r.getInt();
        h2.integrationTime = r.getInt();
        return h2;
    }

    private static FilmHeader readFilmInformationHeader(ByteBuffer r) {
        FilmHeader h2 = new FilmHeader();
        h2.idCode = DPXReader.readNullTermString(r, 2);
        h2.type = DPXReader.readNullTermString(r, 2);
        h2.offset = DPXReader.readNullTermString(r, 2);
        h2.prefix = DPXReader.readNullTermString(r, 6);
        h2.count = DPXReader.readNullTermString(r, 4);
        h2.format = DPXReader.readNullTermString(r, 32);
        return h2;
    }

    private static ImageSourceHeader readImageSourceHeader(ByteBuffer r) {
        ImageSourceHeader h2 = new ImageSourceHeader();
        h2.xOffset = r.getInt();
        h2.yOffset = r.getInt();
        h2.xCenter = r.getFloat();
        h2.yCenter = r.getFloat();
        h2.xOriginal = r.getInt();
        h2.yOriginal = r.getInt();
        h2.sourceImageFilename = DPXReader.readNullTermString(r, 100);
        h2.sourceImageDate = DPXReader.tryParseISO8601Date(DPXReader.readNullTermString(r, 24));
        h2.deviceName = DPXReader.readNullTermString(r, 32);
        h2.deviceSerial = DPXReader.readNullTermString(r, 32);
        h2.borderValidity = new short[]{r.getShort(), r.getShort(), r.getShort(), r.getShort()};
        h2.aspectRatio = new int[]{r.getInt(), r.getInt()};
        return h2;
    }

    private static ImageHeader readImageInfoHeader(ByteBuffer r) {
        ImageHeader h2 = new ImageHeader();
        h2.orientation = r.getShort();
        h2.numberOfImageElements = r.getShort();
        h2.pixelsPerLine = r.getInt();
        h2.linesPerImageElement = r.getInt();
        h2.imageElement1 = new ImageElement();
        h2.imageElement1.dataSign = r.getInt();
        return h2;
    }
}

