/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.autofill;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v131.autofill.model.Address;
import org.openqa.selenium.devtools.v131.autofill.model.AddressFormFilled;
import org.openqa.selenium.devtools.v131.autofill.model.CreditCard;
import org.openqa.selenium.devtools.v131.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v131.page.model.FrameId;

@Beta
public class Autofill {
    public static Command<Void> trigger(BackendNodeId fieldId, Optional<FrameId> frameId, CreditCard card) {
        Objects.requireNonNull(fieldId, "fieldId is required");
        Objects.requireNonNull(card, "card is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("fieldId", fieldId);
        frameId.ifPresent(p -> params.put("frameId", p));
        params.put("card", card);
        return new Command<Void>("Autofill.trigger", Map.copyOf(params));
    }

    public static Command<Void> setAddresses(List<Address> addresses) {
        Objects.requireNonNull(addresses, "addresses is required");
        LinkedHashMap<String, List<Address>> params = new LinkedHashMap<String, List<Address>>();
        params.put("addresses", addresses);
        return new Command<Void>("Autofill.setAddresses", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Autofill.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Autofill.enable", Map.copyOf(params));
    }

    public static Event<AddressFormFilled> addressFormFilled() {
        return new Event<AddressFormFilled>("Autofill.addressFormFilled", input -> (AddressFormFilled)input.read((Type)((Object)AddressFormFilled.class)));
    }
}

