/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.storage;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v132.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v132.network.model.Cookie;
import org.openqa.selenium.devtools.v132.network.model.CookieParam;
import org.openqa.selenium.devtools.v132.page.model.FrameId;
import org.openqa.selenium.devtools.v132.storage.model.AttributionReportingSourceRegistered;
import org.openqa.selenium.devtools.v132.storage.model.AttributionReportingTriggerRegistered;
import org.openqa.selenium.devtools.v132.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v132.storage.model.CacheStorageListUpdated;
import org.openqa.selenium.devtools.v132.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v132.storage.model.IndexedDBListUpdated;
import org.openqa.selenium.devtools.v132.storage.model.InterestGroupAccessed;
import org.openqa.selenium.devtools.v132.storage.model.InterestGroupAuctionEventOccurred;
import org.openqa.selenium.devtools.v132.storage.model.InterestGroupAuctionNetworkRequestCreated;
import org.openqa.selenium.devtools.v132.storage.model.RelatedWebsiteSet;
import org.openqa.selenium.devtools.v132.storage.model.SerializedStorageKey;
import org.openqa.selenium.devtools.v132.storage.model.SharedStorageAccessed;
import org.openqa.selenium.devtools.v132.storage.model.SharedStorageEntry;
import org.openqa.selenium.devtools.v132.storage.model.SharedStorageMetadata;
import org.openqa.selenium.devtools.v132.storage.model.StorageBucket;
import org.openqa.selenium.devtools.v132.storage.model.StorageBucketInfo;
import org.openqa.selenium.devtools.v132.storage.model.TrustTokens;
import org.openqa.selenium.devtools.v132.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<SerializedStorageKey> getStorageKeyForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command<SerializedStorageKey>("Storage.getStorageKeyForFrame", Map.copyOf(params), ConverterFunctions.map("storageKey", SerializedStorageKey.class));
    }

    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command<Void>("Storage.clearDataForOrigin", Map.copyOf(params));
    }

    public static Command<Void> clearDataForStorageKey(String storageKey, String storageTypes) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        params.put("storageTypes", storageTypes);
        return new Command<Void>("Storage.clearDataForStorageKey", Map.copyOf(params));
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<List<Cookie>>("Storage.getCookies", Map.copyOf(params), ConverterFunctions.map("cookies", input -> input.readArray((Type)((Object)Cookie.class))));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        LinkedHashMap<String, List<CookieParam>> params = new LinkedHashMap<String, List<CookieParam>>();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<CookieParam>)p));
        return new Command<Void>("Storage.setCookies", Map.copyOf(params));
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Storage.clearCookies", Map.copyOf(params));
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<GetUsageAndQuotaResponse>("Storage.getUsageAndQuota", Map.copyOf(params), input -> (GetUsageAndQuotaResponse)input.read((Type)((Object)GetUsageAndQuotaResponse.class)));
    }

    @Beta
    public static Command<Void> overrideQuotaForOrigin(String origin, Optional<Number> quotaSize) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        quotaSize.ifPresent(p -> params.put("quotaSize", (String)p));
        return new Command<Void>("Storage.overrideQuotaForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackCacheStorageForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.trackCacheStorageForStorageKey", Map.copyOf(params));
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackIndexedDBForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.trackIndexedDBForStorageKey", Map.copyOf(params));
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackCacheStorageForOrigin", Map.copyOf(params));
    }

    public static Command<Void> untrackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.untrackCacheStorageForStorageKey", Map.copyOf(params));
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackIndexedDBForOrigin", Map.copyOf(params));
    }

    public static Command<Void> untrackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.untrackIndexedDBForStorageKey", Map.copyOf(params));
    }

    @Beta
    public static Command<List<TrustTokens>> getTrustTokens() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<TrustTokens>>("Storage.getTrustTokens", Map.copyOf(params), ConverterFunctions.map("tokens", input -> input.readArray((Type)((Object)TrustTokens.class))));
    }

    @Beta
    public static Command<Boolean> clearTrustTokens(String issuerOrigin) {
        Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("issuerOrigin", issuerOrigin);
        return new Command<Boolean>("Storage.clearTrustTokens", Map.copyOf(params), ConverterFunctions.map("didDeleteTokens", Boolean.class));
    }

    @Beta
    public static Command<Map<String, Object>> getInterestGroupDetails(String ownerOrigin, String name) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("name", name);
        return new Command<Map<String, Object>>("Storage.getInterestGroupDetails", Map.copyOf(params), ConverterFunctions.map("details", Map.class));
    }

    @Beta
    public static Command<Void> setInterestGroupTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command<Void>("Storage.setInterestGroupTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setInterestGroupAuctionTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command<Void>("Storage.setInterestGroupAuctionTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<SharedStorageMetadata> getSharedStorageMetadata(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<SharedStorageMetadata>("Storage.getSharedStorageMetadata", Map.copyOf(params), ConverterFunctions.map("metadata", SharedStorageMetadata.class));
    }

    @Beta
    public static Command<List<SharedStorageEntry>> getSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<List<SharedStorageEntry>>("Storage.getSharedStorageEntries", Map.copyOf(params), ConverterFunctions.map("entries", input -> input.readArray((Type)((Object)SharedStorageEntry.class))));
    }

    @Beta
    public static Command<Void> setSharedStorageEntry(String ownerOrigin, String key, String value, Optional<Boolean> ignoreIfPresent) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        params.put("value", value);
        ignoreIfPresent.ifPresent(p -> params.put("ignoreIfPresent", (String)p));
        return new Command<Void>("Storage.setSharedStorageEntry", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> deleteSharedStorageEntry(String ownerOrigin, String key) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        return new Command<Void>("Storage.deleteSharedStorageEntry", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<Void>("Storage.clearSharedStorageEntries", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> resetSharedStorageBudget(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<Void>("Storage.resetSharedStorageBudget", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setSharedStorageTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command<Void>("Storage.setSharedStorageTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setStorageBucketTracking(String storageKey, Boolean enable) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("storageKey", storageKey);
        params.put("enable", enable);
        return new Command<Void>("Storage.setStorageBucketTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> deleteStorageBucket(StorageBucket bucket) {
        Objects.requireNonNull(bucket, "bucket is required");
        LinkedHashMap<String, StorageBucket> params = new LinkedHashMap<String, StorageBucket>();
        params.put("bucket", bucket);
        return new Command<Void>("Storage.deleteStorageBucket", Map.copyOf(params));
    }

    @Beta
    public static Command<List<String>> runBounceTrackingMitigations() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<String>>("Storage.runBounceTrackingMitigations", Map.copyOf(params), ConverterFunctions.map("deletedSites", input -> input.readArray((Type)((Object)String.class))));
    }

    @Beta
    public static Command<Void> setAttributionReportingLocalTestingMode(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Storage.setAttributionReportingLocalTestingMode", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setAttributionReportingTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command<Void>("Storage.setAttributionReportingTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Integer> sendPendingAttributionReports() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Integer>("Storage.sendPendingAttributionReports", Map.copyOf(params), ConverterFunctions.map("numSent", Integer.class));
    }

    @Beta
    public static Command<List<RelatedWebsiteSet>> getRelatedWebsiteSets() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<RelatedWebsiteSet>>("Storage.getRelatedWebsiteSets", Map.copyOf(params), ConverterFunctions.map("sets", input -> input.readArray((Type)((Object)RelatedWebsiteSet.class))));
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<CacheStorageContentUpdated>("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read((Type)((Object)CacheStorageContentUpdated.class)));
    }

    public static Event<CacheStorageListUpdated> cacheStorageListUpdated() {
        return new Event<CacheStorageListUpdated>("Storage.cacheStorageListUpdated", input -> (CacheStorageListUpdated)input.read((Type)((Object)CacheStorageListUpdated.class)));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<IndexedDBContentUpdated>("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read((Type)((Object)IndexedDBContentUpdated.class)));
    }

    public static Event<IndexedDBListUpdated> indexedDBListUpdated() {
        return new Event<IndexedDBListUpdated>("Storage.indexedDBListUpdated", input -> (IndexedDBListUpdated)input.read((Type)((Object)IndexedDBListUpdated.class)));
    }

    public static Event<InterestGroupAccessed> interestGroupAccessed() {
        return new Event<InterestGroupAccessed>("Storage.interestGroupAccessed", input -> (InterestGroupAccessed)input.read((Type)((Object)InterestGroupAccessed.class)));
    }

    public static Event<InterestGroupAuctionEventOccurred> interestGroupAuctionEventOccurred() {
        return new Event<InterestGroupAuctionEventOccurred>("Storage.interestGroupAuctionEventOccurred", input -> (InterestGroupAuctionEventOccurred)input.read((Type)((Object)InterestGroupAuctionEventOccurred.class)));
    }

    public static Event<InterestGroupAuctionNetworkRequestCreated> interestGroupAuctionNetworkRequestCreated() {
        return new Event<InterestGroupAuctionNetworkRequestCreated>("Storage.interestGroupAuctionNetworkRequestCreated", input -> (InterestGroupAuctionNetworkRequestCreated)input.read((Type)((Object)InterestGroupAuctionNetworkRequestCreated.class)));
    }

    public static Event<SharedStorageAccessed> sharedStorageAccessed() {
        return new Event<SharedStorageAccessed>("Storage.sharedStorageAccessed", input -> (SharedStorageAccessed)input.read((Type)((Object)SharedStorageAccessed.class)));
    }

    public static Event<StorageBucketInfo> storageBucketCreatedOrUpdated() {
        return new Event<StorageBucketInfo>("Storage.storageBucketCreatedOrUpdated", ConverterFunctions.map("bucketInfo", StorageBucketInfo.class));
    }

    public static Event<String> storageBucketDeleted() {
        return new Event<String>("Storage.storageBucketDeleted", ConverterFunctions.map("bucketId", String.class));
    }

    public static Event<AttributionReportingSourceRegistered> attributionReportingSourceRegistered() {
        return new Event<AttributionReportingSourceRegistered>("Storage.attributionReportingSourceRegistered", input -> (AttributionReportingSourceRegistered)input.read((Type)((Object)AttributionReportingSourceRegistered.class)));
    }

    public static Event<AttributionReportingTriggerRegistered> attributionReportingTriggerRegistered() {
        return new Event<AttributionReportingTriggerRegistered>("Storage.attributionReportingTriggerRegistered", input -> (AttributionReportingTriggerRegistered)input.read((Type)((Object)AttributionReportingTriggerRegistered.class)));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final Boolean overrideActive;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, Boolean overrideActive, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public Boolean getOverrideActive() {
            return this.overrideActive;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            Boolean overrideActive = false;
            List usageBreakdown = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block12;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block12;
                    }
                    case "overrideActive": {
                        overrideActive = input.nextBoolean();
                        continue block12;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = input.readArray((Type)((Object)UsageForType.class));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }
}

