/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.filesystem.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v133.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class File {
    private final String name;
    private final TimeSinceEpoch lastModified;
    private final Number size;
    private final String type;

    public File(String name, TimeSinceEpoch lastModified, Number size, String type) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.lastModified = Objects.requireNonNull(lastModified, "lastModified is required");
        this.size = Objects.requireNonNull(size, "size is required");
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public String getName() {
        return this.name;
    }

    public TimeSinceEpoch getLastModified() {
        return this.lastModified;
    }

    public Number getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    private static File fromJson(JsonInput input) {
        String name = null;
        TimeSinceEpoch lastModified = null;
        Number size = 0;
        String type = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "lastModified": {
                    lastModified = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block12;
                }
                case "size": {
                    size = input.nextNumber();
                    continue block12;
                }
                case "type": {
                    type = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new File(name, lastModified, size, type);
    }
}

