/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Directives;
import graphql.ExperimentalApi;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLObjectType;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@ExperimentalApi
public class DeferDirectiveOnRootLevel
extends AbstractRule {
    private Set<OperationDefinition.Operation> invalidOperations = new LinkedHashSet<OperationDefinition.Operation>(Arrays.asList(OperationDefinition.Operation.MUTATION, OperationDefinition.Operation.SUBSCRIPTION));

    public DeferDirectiveOnRootLevel(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
        this.setVisitFragmentSpreads(true);
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        if (!this.isExperimentalApiKeyEnabled("ENABLE_INCREMENTAL_SUPPORT").booleanValue()) {
            return;
        }
        if (!Directives.DeferDirective.getName().equals(directive.getName())) {
            return;
        }
        GraphQLObjectType mutationType = this.getValidationContext().getSchema().getMutationType();
        GraphQLObjectType subscriptionType = this.getValidationContext().getSchema().getSubscriptionType();
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (mutationType != null && parentType != null && parentType.getName().equals(mutationType.getName())) {
            String message = this.i18n(ValidationErrorType.MisplacedDirective, "DeferDirective.notAllowedOperationRootLevelMutation", parentType.getName());
            this.addError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message);
        } else if (subscriptionType != null && parentType != null && parentType.getName().equals(subscriptionType.getName())) {
            String message = this.i18n(ValidationErrorType.MisplacedDirective, "DeferDirective.notAllowedOperationRootLevelSubscription", parentType.getName());
            this.addError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message);
        }
    }
}

