/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.PublicApi;
import graphql.PublicSpi;
import graphql.Scalars;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.AstPrinter;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.InputValueWithState;
import graphql.schema.SchemaTransformer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class IntrospectionWithDirectivesSupport {
    private final DirectivePredicate directivePredicate;
    private final String typePrefix;
    private final Set<String> INTROSPECTION_ELEMENTS = ImmutableSet.of(Introspection.__Schema.getName(), Introspection.__Type.getName(), Introspection.__Field.getName(), Introspection.__EnumValue.getName(), Introspection.__InputValue.getName());

    public IntrospectionWithDirectivesSupport() {
        this(env -> true);
    }

    public IntrospectionWithDirectivesSupport(DirectivePredicate directivePredicate) {
        this(directivePredicate, "_");
    }

    public IntrospectionWithDirectivesSupport(DirectivePredicate directivePredicate, String typePrefix) {
        this.directivePredicate = Assert.assertNotNull(directivePredicate);
        this.typePrefix = Assert.assertNotNull(typePrefix);
    }

    public GraphQLSchema apply(GraphQLSchema schema) {
        final GraphQLObjectType directiveArgumentType = this.mkDirectiveArgumentType(this.typePrefix + "DirectiveArgument");
        final GraphQLObjectType appliedDirectiveType = this.mkAppliedDirectiveType(this.typePrefix + "AppliedDirective", directiveArgumentType);
        GraphQLTypeVisitorStub visitor = new GraphQLTypeVisitorStub(){

            @Override
            public TraversalControl visitGraphQLObjectType(GraphQLObjectType objectType, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLCodeRegistry.Builder codeRegistry = context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
                if (IntrospectionWithDirectivesSupport.this.INTROSPECTION_ELEMENTS.contains(objectType.getName())) {
                    GraphQLObjectType newObjectType = IntrospectionWithDirectivesSupport.this.addAppliedDirectives(objectType, codeRegistry, appliedDirectiveType, directiveArgumentType);
                    return this.changeNode(context, newObjectType);
                }
                return TraversalControl.CONTINUE;
            }
        };
        GraphQLSchema newSchema = SchemaTransformer.transformSchema(schema, (GraphQLTypeVisitor)visitor);
        return this.addDirectiveDefinitionFilter(newSchema);
    }

    private GraphQLObjectType mkDirectiveArgumentType(String name) {
        return GraphQLObjectType.newObject().name(name).description("Directive arguments can have names and values.  The values are in graphql SDL syntax printed as a string. This type is NOT specified by the graphql specification presently.").field(fld -> fld.name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(fld -> fld.name("value").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).build();
    }

    private GraphQLObjectType mkAppliedDirectiveType(String name, GraphQLType directiveArgumentType) {
        return GraphQLObjectType.newObject().name(name).description("An Applied Directive is an instances of a directive as applied to a schema element. This type is NOT specified by the graphql specification presently.").field(fld -> fld.name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(fld -> fld.name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(directiveArgumentType))))).build();
    }

    private GraphQLSchema addDirectiveDefinitionFilter(GraphQLSchema schema) {
        DataFetcher<Object> df = env -> {
            List<GraphQLDirective> definedDirectives = env.getGraphQLSchema().getDirectives();
            return this.filterDirectives(schema, true, null, definedDirectives);
        };
        GraphQLCodeRegistry codeRegistry = schema.getCodeRegistry().transform(bld -> bld.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)Introspection.__Schema, "directives"), df));
        return schema.transform(bld -> bld.codeRegistry(codeRegistry));
    }

    private GraphQLObjectType addAppliedDirectives(GraphQLObjectType originalType, GraphQLCodeRegistry.Builder codeRegistry, GraphQLObjectType appliedDirectiveType, GraphQLObjectType directiveArgumentType) {
        GraphQLObjectType objectType = originalType.transform(bld -> bld.field(fld -> fld.name("appliedDirectives").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(appliedDirectiveType))))));
        DataFetcher<Object> df = env -> {
            Object source = env.getSource();
            GraphQLSchema schema = env.getGraphQLSchema();
            if (source instanceof GraphQLDirectiveContainer) {
                GraphQLDirectiveContainer type = (GraphQLDirectiveContainer)env.getSource();
                List<GraphQLAppliedDirective> appliedDirectives = DirectivesUtil.toAppliedDirectives(type);
                return this.filterAppliedDirectives(schema, false, type, appliedDirectives);
            }
            if (source instanceof GraphQLSchema) {
                List<GraphQLAppliedDirective> appliedDirectives = DirectivesUtil.toAppliedDirectives(schema.getSchemaAppliedDirectives(), schema.getSchemaDirectives());
                return this.filterAppliedDirectives(schema, true, null, appliedDirectives);
            }
            return Assert.assertShouldNeverHappen("What directive containing element have we not considered? - %s", originalType);
        };
        DataFetcher<Object> argsDF = env -> {
            GraphQLAppliedDirective directive = (GraphQLAppliedDirective)env.getSource();
            return directive.getArguments().stream().filter(arg -> arg.getArgumentValue().isSet());
        };
        DataFetcher<Object> argValueDF = env -> {
            GraphQLAppliedDirectiveArgument argument = (GraphQLAppliedDirectiveArgument)env.getSource();
            InputValueWithState value = argument.getArgumentValue();
            Value<?> literal = ValuesResolver.valueToLiteral(value, argument.getType(), env.getGraphQlContext(), env.getLocale());
            return AstPrinter.printAst(literal);
        };
        DataFetcher<Object> nameDF = env -> {
            if (env.getSource() instanceof GraphQLNamedSchemaElement) {
                return ((GraphQLNamedSchemaElement)env.getSource()).getName();
            }
            return null;
        };
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)objectType, "appliedDirectives"), df);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)appliedDirectiveType, "name"), nameDF);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)appliedDirectiveType, "args"), argsDF);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)directiveArgumentType, "name"), nameDF);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)directiveArgumentType, "value"), argValueDF);
        return objectType;
    }

    private List<GraphQLDirective> filterDirectives(GraphQLSchema schema, boolean isDefinedDirective, GraphQLDirectiveContainer container, List<GraphQLDirective> directives) {
        return directives.stream().filter(directive -> {
            DirectivePredicateEnvironment env = this.buildDirectivePredicateEnv(schema, isDefinedDirective, container, directive.getName());
            return this.directivePredicate.isDirectiveIncluded(env);
        }).collect(Collectors.toList());
    }

    private List<GraphQLAppliedDirective> filterAppliedDirectives(GraphQLSchema schema, boolean isDefinedDirective, GraphQLDirectiveContainer container, List<GraphQLAppliedDirective> directives) {
        return directives.stream().filter(directive -> {
            DirectivePredicateEnvironment env = this.buildDirectivePredicateEnv(schema, isDefinedDirective, container, directive.getName());
            return this.directivePredicate.isDirectiveIncluded(env);
        }).collect(Collectors.toList());
    }

    @NotNull
    private DirectivePredicateEnvironment buildDirectivePredicateEnv(final GraphQLSchema schema, final boolean isDefinedDirective, final GraphQLDirectiveContainer container, final String directiveName) {
        return new DirectivePredicateEnvironment(){

            @Override
            public GraphQLDirectiveContainer getDirectiveContainer() {
                return container;
            }

            @Override
            public boolean isDefinedDirective() {
                return isDefinedDirective;
            }

            @Override
            public String getDirectiveName() {
                return directiveName;
            }

            @Override
            public GraphQLSchema getSchema() {
                return schema;
            }
        };
    }

    @PublicSpi
    @FunctionalInterface
    public static interface DirectivePredicate {
        public boolean isDirectiveIncluded(DirectivePredicateEnvironment var1);
    }

    @PublicApi
    public static interface DirectivePredicateEnvironment {
        public GraphQLDirectiveContainer getDirectiveContainer();

        public String getDirectiveName();

        public boolean isDefinedDirective();

        public GraphQLSchema getSchema();
    }
}

