/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class FileUtilsCleanDirectoryTest
extends AbstractTempDirTest {
    private boolean chmod(File file, int mode, boolean recurse) throws InterruptedException {
        Process proc;
        ArrayList<String> args = new ArrayList<String>();
        args.add("chmod");
        if (recurse) {
            args.add("-R");
        }
        args.add(Integer.toString(mode));
        args.add(file.getAbsolutePath());
        try {
            proc = Runtime.getRuntime().exec(args.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        catch (IOException e) {
            return false;
        }
        return proc.waitFor() == 0;
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testCleanDirectoryToForceDelete() throws Exception {
        File file = new File(this.tempDirFile, "restricted");
        FileUtils.touch((File)file);
        Assumptions.assumeTrue((boolean)this.chmod(this.tempDirFile, 700, false));
        FileUtils.cleanDirectory((File)this.tempDirFile);
    }

    @Test
    public void testCleanEmpty() throws Exception {
        Assertions.assertEquals((int)0, (int)this.tempDirFile.list().length);
        FileUtils.cleanDirectory((File)this.tempDirFile);
        Assertions.assertEquals((int)0, (int)this.tempDirFile.list().length);
    }

    @Test
    public void testDeletesNested() throws Exception {
        File nested = new File(this.tempDirFile, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        FileUtils.touch((File)new File(nested, "file"));
        Assertions.assertEquals((int)1, (int)this.tempDirFile.list().length);
        FileUtils.cleanDirectory((File)this.tempDirFile);
        Assertions.assertEquals((int)0, (int)this.tempDirFile.list().length);
    }

    @Test
    public void testDeletesRegular() throws Exception {
        FileUtils.touch((File)new File(this.tempDirFile, "regular"));
        FileUtils.touch((File)new File(this.tempDirFile, ".hidden"));
        Assertions.assertEquals((int)2, (int)this.tempDirFile.list().length);
        FileUtils.cleanDirectory((File)this.tempDirFile);
        Assertions.assertEquals((int)0, (int)this.tempDirFile.list().length);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrowsOnNullList() throws Exception {
        Assumptions.assumeTrue((boolean)this.chmod(this.tempDirFile, 0, false));
        try {
            IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> FileUtils.cleanDirectory((File)this.tempDirFile));
            Assertions.assertEquals((Object)("Unknown I/O error listing contents of directory: " + this.tempDirFile.getAbsolutePath()), (Object)e.getMessage());
        }
        finally {
            this.chmod(this.tempDirFile, 755, false);
        }
    }
}

