/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOCaseTest {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    private void assert0(byte[] arr) {
        for (byte e : arr) {
            Assertions.assertEquals((int)0, (int)e);
        }
    }

    private void assert0(char[] arr) {
        for (char e : arr) {
            Assertions.assertEquals((int)0, (int)e);
        }
    }

    private IOCase serialize(IOCase value) throws Exception {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(buf);){
            out.writeObject(value);
            out.flush();
        }
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        return (IOCase)in.readObject();
    }

    @Test
    public void test_checkCompare_case() {
        Assertions.assertEquals((int)0, (int)IOCase.SENSITIVE.checkCompareTo("ABC", "ABC"));
        Assertions.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "abc") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((IOCase.SENSITIVE.checkCompareTo("abc", "ABC") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)IOCase.INSENSITIVE.checkCompareTo("ABC", "ABC"));
        Assertions.assertEquals((int)0, (int)IOCase.INSENSITIVE.checkCompareTo("ABC", "abc"));
        Assertions.assertEquals((int)0, (int)IOCase.INSENSITIVE.checkCompareTo("abc", "ABC"));
        Assertions.assertEquals((int)0, (int)IOCase.SYSTEM.checkCompareTo("ABC", "ABC"));
        Assertions.assertEquals((Object)WINDOWS, (Object)(IOCase.SYSTEM.checkCompareTo("ABC", "abc") == 0 ? 1 : 0));
        Assertions.assertEquals((Object)WINDOWS, (Object)(IOCase.SYSTEM.checkCompareTo("abc", "ABC") == 0 ? 1 : 0));
    }

    @Test
    public void test_checkCompare_functionality() {
        Assertions.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((IOCase.SENSITIVE.checkCompareTo("", "ABC") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "DEF") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((IOCase.SENSITIVE.checkCompareTo("DEF", "ABC") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)IOCase.SENSITIVE.checkCompareTo("ABC", "ABC"));
        Assertions.assertEquals((int)0, (int)IOCase.SENSITIVE.checkCompareTo("", ""));
        Assertions.assertThrows(NullPointerException.class, () -> IOCase.SENSITIVE.checkCompareTo("ABC", null));
        Assertions.assertThrows(NullPointerException.class, () -> IOCase.SENSITIVE.checkCompareTo(null, "ABC"));
        Assertions.assertThrows(NullPointerException.class, () -> IOCase.SENSITIVE.checkCompareTo(null, null));
    }

    @Test
    public void test_checkEndsWith_case() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "BC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "Bc"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkEndsWith("ABC", "BC"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkEndsWith("ABC", "Bc"));
        Assertions.assertTrue((boolean)IOCase.SYSTEM.checkEndsWith("ABC", "BC"));
        Assertions.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkEndsWith("ABC", "Bc"));
    }

    @Test
    public void test_checkEndsWith_functionality() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "A"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "AB"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "BC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "C"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "ABCD"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("", "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("", ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", null));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith(null, "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith(null, null));
    }

    @Test
    public void test_checkEquals_case() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "Abc"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkEquals("ABC", "ABC"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkEquals("ABC", "Abc"));
        Assertions.assertTrue((boolean)IOCase.SYSTEM.checkEquals("ABC", "ABC"));
        Assertions.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkEquals("ABC", "Abc"));
    }

    @Test
    public void test_checkEquals_functionality() {
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "A"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "AB"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "BC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "C"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABCD"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("", "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("", ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", null));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkEquals(null, "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkEquals(null, null));
    }

    @Test
    public void test_checkIndexOf_case() {
        Assertions.assertEquals((int)1, (int)IOCase.SENSITIVE.checkIndexOf("ABC", 0, "BC"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABC", 0, "Bc"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf(null, 0, "Bc"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf(null, 0, null));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABC", 0, null));
        Assertions.assertEquals((int)1, (int)IOCase.INSENSITIVE.checkIndexOf("ABC", 0, "BC"));
        Assertions.assertEquals((int)1, (int)IOCase.INSENSITIVE.checkIndexOf("ABC", 0, "Bc"));
        Assertions.assertEquals((int)1, (int)IOCase.SYSTEM.checkIndexOf("ABC", 0, "BC"));
        Assertions.assertEquals((int)(WINDOWS ? 1 : -1), (int)IOCase.SYSTEM.checkIndexOf("ABC", 0, "Bc"));
    }

    @Test
    public void test_checkIndexOf_functionality() {
        Assertions.assertEquals((int)0, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "A"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "A"));
        Assertions.assertEquals((int)0, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "AB"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "AB"));
        Assertions.assertEquals((int)0, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "ABC"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "ABC"));
        Assertions.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "D"));
        Assertions.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "D"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "D"));
        Assertions.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DE"));
        Assertions.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "DE"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "DE"));
        Assertions.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DEF"));
        Assertions.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "DEF"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "DEF"));
        Assertions.assertEquals((int)9, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "J"));
        Assertions.assertEquals((int)9, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "J"));
        Assertions.assertEquals((int)9, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 9, "J"));
        Assertions.assertEquals((int)8, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "IJ"));
        Assertions.assertEquals((int)8, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "IJ"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 9, "IJ"));
        Assertions.assertEquals((int)7, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 6, "HIJ"));
        Assertions.assertEquals((int)7, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 7, "HIJ"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "HIJ"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DED"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("DEF", 0, "ABCDEFGHIJ"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABC", 0, null));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf(null, 0, "ABC"));
        Assertions.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf(null, 0, null));
    }

    @Test
    public void test_checkRegionMatches_case() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "Ab"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkRegionMatches("ABC", 0, "Ab"));
        Assertions.assertTrue((boolean)IOCase.SYSTEM.checkRegionMatches("ABC", 0, "AB"));
        Assertions.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkRegionMatches("ABC", 0, "Ab"));
    }

    @Test
    public void test_checkRegionMatches_functionality() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, ""));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "A"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "BC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "C"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "ABCD"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 0, "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("", 0, ""));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "A"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "AB"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "BC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "C"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "ABCD"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 1, "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 1, ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, null));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches(null, 0, "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches(null, 0, null));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, null));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches(null, 1, "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches(null, 1, null));
    }

    @Test
    public void test_checkStartsWith_case() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "AB"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "Ab"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkStartsWith("ABC", "AB"));
        Assertions.assertTrue((boolean)IOCase.INSENSITIVE.checkStartsWith("ABC", "Ab"));
        Assertions.assertTrue((boolean)IOCase.SYSTEM.checkStartsWith("ABC", "AB"));
        Assertions.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkStartsWith("ABC", "Ab"));
    }

    @Test
    public void test_checkStartsWith_functionality() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", ""));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "A"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "AB"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "BC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "C"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "ABCD"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("", "ABC"));
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("", ""));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", null));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith(null, "ABC"));
        Assertions.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith(null, null));
    }

    @Test
    public void test_forName() {
        Assertions.assertEquals((Object)IOCase.SENSITIVE, (Object)IOCase.forName((String)"Sensitive"));
        Assertions.assertEquals((Object)IOCase.INSENSITIVE, (Object)IOCase.forName((String)"Insensitive"));
        Assertions.assertEquals((Object)IOCase.SYSTEM, (Object)IOCase.forName((String)"System"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOCase.forName((String)"Blah"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOCase.forName(null));
    }

    @Test
    public void test_getName() {
        Assertions.assertEquals((Object)"Sensitive", (Object)IOCase.SENSITIVE.getName());
        Assertions.assertEquals((Object)"Insensitive", (Object)IOCase.INSENSITIVE.getName());
        Assertions.assertEquals((Object)"System", (Object)IOCase.SYSTEM.getName());
    }

    @Test
    public void test_getScratchByteArray() {
        byte[] array = IOUtils.getScratchByteArray();
        this.assert0(array);
        Arrays.fill(array, (byte)1);
        this.assert0(IOUtils.getScratchCharArray());
    }

    @Test
    public void test_getScratchByteArrayWriteOnly() {
        byte[] array = IOUtils.getScratchByteArrayWriteOnly();
        this.assert0(array);
        Arrays.fill(array, (byte)1);
        this.assert0(IOUtils.getScratchCharArray());
    }

    @Test
    public void test_getScratchCharArray() {
        char[] array = IOUtils.getScratchCharArray();
        this.assert0(array);
        Arrays.fill(array, '\u0001');
        this.assert0(IOUtils.getScratchCharArray());
    }

    @Test
    public void test_getScratchCharArrayWriteOnly() {
        char[] array = IOUtils.getScratchCharArrayWriteOnly();
        this.assert0(array);
        Arrays.fill(array, '\u0001');
        this.assert0(IOUtils.getScratchCharArray());
    }

    @Test
    public void test_isCaseSensitive() {
        Assertions.assertTrue((boolean)IOCase.SENSITIVE.isCaseSensitive());
        Assertions.assertFalse((boolean)IOCase.INSENSITIVE.isCaseSensitive());
        Assertions.assertEquals((Object)(!WINDOWS ? 1 : 0), (Object)IOCase.SYSTEM.isCaseSensitive());
    }

    @Test
    public void test_isCaseSensitive_static() {
        Assertions.assertTrue((boolean)IOCase.isCaseSensitive((IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)IOCase.isCaseSensitive((IOCase)IOCase.INSENSITIVE));
        Assertions.assertEquals((Object)(!WINDOWS ? 1 : 0), (Object)IOCase.isCaseSensitive((IOCase)IOCase.SYSTEM));
    }

    @Test
    public void test_serialization() throws Exception {
        Assertions.assertSame((Object)IOCase.SENSITIVE, (Object)this.serialize(IOCase.SENSITIVE));
        Assertions.assertSame((Object)IOCase.INSENSITIVE, (Object)this.serialize(IOCase.INSENSITIVE));
        Assertions.assertSame((Object)IOCase.SYSTEM, (Object)this.serialize(IOCase.SYSTEM));
    }

    @Test
    public void test_toString() {
        Assertions.assertEquals((Object)"Sensitive", (Object)IOCase.SENSITIVE.toString());
        Assertions.assertEquals((Object)"Insensitive", (Object)IOCase.INSENSITIVE.toString());
        Assertions.assertEquals((Object)"System", (Object)IOCase.SYSTEM.toString());
    }
}

