/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import org.apache.commons.io.input.BrokenReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class BrokenReaderTest {
    private static BrokenReader createBrokenReader(Throwable exception) {
        if (exception instanceof IOException) {
            return new BrokenReader((IOException)exception);
        }
        return new BrokenReader(exception);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testClose(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.close()));
    }

    @Test
    public void testInstance() {
        Assertions.assertNotNull((Object)BrokenReader.INSTANCE);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testMark(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.mark(1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testRead(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.read()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testReadCharArray(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.read(new char[1])));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testReadCharArrayIndexed(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.read(new char[1], 0, 1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testReady(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.ready()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testReset(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.reset()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    public void testSkip(Class<Throwable> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenReader brokenReader = BrokenReaderTest.createBrokenReader(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> brokenReader.skip(1L)));
    }

    @Test
    public void testTryWithResources() {
        IOException thrown = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (BrokenReader newReader = new BrokenReader();){
                newReader.read();
            }
        });
        Assertions.assertEquals((Object)"Broken reader", (Object)thrown.getMessage());
        Throwable[] suppressed = thrown.getSuppressed();
        Assertions.assertEquals((int)1, (int)suppressed.length);
        Assertions.assertEquals(IOException.class, suppressed[0].getClass());
        Assertions.assertEquals((Object)"Broken reader", (Object)suppressed[0].getMessage());
    }
}

