/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.MessageDigestInputStream;
import org.apache.commons.io.test.CustomIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageDigestInputStreamTest {
    static byte[] generateRandomByteStream(int pSize) {
        byte[] buffer = new byte[pSize];
        Random rnd = new Random();
        rnd.nextBytes(buffer);
        return buffer;
    }

    private InputStream createInputStream() throws IOException, NoSuchAlgorithmException {
        return this.createInputStream(new ByteArrayInputStream(MessageDigestInputStreamTest.generateRandomByteStream(256)));
    }

    private InputStream createInputStream(InputStream origin) throws IOException, NoSuchAlgorithmException {
        return ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setMessageDigest(MessageDigest.getInstance("SHA-512")).setInputStream(origin)).get();
    }

    @Test
    public void testAfterReadConsumer() throws Exception {
        AtomicBoolean boolRef = new AtomicBoolean();
        try (MessageDigestInputStream bounded = ((MessageDigestInputStream.Builder)((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setMessageDigest(MessageDigest.getInstance("SHA-512")).setCharSequence((CharSequence)"Hi")).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume((InputStream)bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (MessageDigestInputStream bounded = ((MessageDigestInputStream.Builder)((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setMessageDigest(MessageDigest.getInstance("SHA-512")).setCharSequence((CharSequence)"Hi")).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertTrue((boolean)((IOExceptionList)Assertions.assertThrowsExactly(IOExceptionList.class, () -> MessageDigestInputStreamTest.lambda$testAfterReadConsumer$2((InputStream)bounded))).getMessage().contains("test exception message"));
        }
    }

    @Test
    public void testAvailableAfterClose() throws Exception {
        InputStream shadow;
        try (InputStream in = this.createInputStream();){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @Test
    public void testAvailableAfterOpen() throws Exception {
        try (InputStream in = this.createInputStream();){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertNotEquals((int)-1, (int)in.read());
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoDefault() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> MessageDigestInputStream.builder().get());
        Assertions.assertThrows(NullPointerException.class, () -> ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(new byte[]{1}))).get());
    }

    @Test
    public void testNormalUse() throws Exception {
        for (int i = 256; i < 8192; i *= 2) {
            byte[] buffer = MessageDigestInputStreamTest.generateRandomByteStream(i);
            byte[] expect = DigestUtils.sha512((byte[])buffer);
            try (MessageDigestInputStream messageDigestInputStream = ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setMessageDigest("SHA-512").setInputStream((InputStream)new ByteArrayInputStream(buffer))).get();){
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            messageDigestInputStream = ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setByteArray(buffer)).setMessageDigest(DigestUtils.getSha512Digest()).get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
                continue;
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
        }
    }

    @Test
    public void testReadAfterClose_ByteArrayInputStream() throws Exception {
        try (InputStream in = this.createInputStream();){
            in.close();
            Assertions.assertNotEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testReadAfterClose_ChannelInputStream() throws Exception {
        try (InputStream in = this.createInputStream(Files.newInputStream(Paths.get("src/test/resources/org/apache/commons/io/abitmorethan16k.txt", new String[0]), new OpenOption[0]));){
            in.close();
            Assertions.assertThrows(IOException.class, in::read);
        }
    }

    private static /* synthetic */ void lambda$testAfterReadConsumer$2(InputStream bounded) throws Throwable {
        IOUtils.consume((InputStream)bounded);
    }
}

