/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.test.CustomIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ProxyInputStreamTest<T extends ProxyInputStream> {
    static <T, B extends AbstractStreamBuilder<T, B>> void testCloseHandleIOException(AbstractStreamBuilder<T, B> builder) throws IOException {
        IOException exception = new IOException();
        ProxyInputStreamTest.testCloseHandleIOException((ProxyInputStream)((AbstractStreamBuilder)builder.setInputStream((InputStream)new BrokenInputStream(() -> exception))).get());
    }

    static void testCloseHandleIOException(ProxyInputStream inputStream) throws IOException {
        Assertions.assertFalse((boolean)inputStream.isClosed(), (String)"closed");
        ProxyInputStream spy = (ProxyInputStream)Mockito.spy((Object)inputStream);
        Assertions.assertThrows(IOException.class, () -> ((ProxyInputStream)spy).close());
        BrokenInputStream unwrap = (BrokenInputStream)inputStream.unwrap();
        ((ProxyInputStream)Mockito.verify((Object)spy)).handleIOException((IOException)unwrap.getThrowable());
        Assertions.assertFalse((boolean)spy.isClosed(), (String)"closed");
    }

    protected void assertMarkSupportedEquals(ProxyInputStream inputStream) {
        Assertions.assertNotNull((Object)inputStream, (String)"inputStream");
        Assertions.assertEquals((Object)inputStream.unwrap().markSupported(), (Object)inputStream.markSupported());
    }

    protected T createFixture() throws IOException {
        return (T)((Object)new ProxyInputStreamFixture(this.createOriginInputStream()));
    }

    protected T createFixture(InputStream proxy) {
        return (T)((Object)new ProxyInputStreamFixture(proxy));
    }

    protected InputStream createOriginInputStream() {
        return ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)"abc")).get();
    }

    @Test
    public void testAvailableAfterClose() throws IOException {
        T shadow;
        try (T inputStream = this.createFixture();){
            shadow = inputStream;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @Test
    public void testAvailableAfterOpen() throws IOException {
        try (T inputStream = this.createFixture();){
            Assertions.assertEquals((int)3, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableAll() throws IOException {
        try (T inputStream = this.createFixture();){
            Assertions.assertEquals((int)3, (int)inputStream.available());
            IOUtils.toByteArray(inputStream);
            Assertions.assertEquals((int)0, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableNull() throws IOException {
        try (T inputStream = this.createFixture(null);){
            Assertions.assertEquals((int)0, (int)inputStream.available());
            inputStream.setIn(this.createFixture());
            Assertions.assertEquals((int)3, (int)inputStream.available());
            IOUtils.toByteArray(inputStream);
            Assertions.assertEquals((int)0, (int)inputStream.available());
            inputStream.setIn(null);
            Assertions.assertEquals((int)0, (int)inputStream.available());
        }
    }

    protected void testEos(T inputStream) {
    }

    public void testMarkOnNull() throws IOException {
        try (T inputStream = this.createFixture(null);){
            inputStream.mark(1);
            inputStream.setIn(this.createFixture());
            inputStream.mark(1);
            IOUtils.toByteArray(inputStream);
            inputStream.mark(1);
            inputStream.setIn(null);
            inputStream.mark(1);
        }
    }

    @Test
    public void testMarkSupported() throws IOException {
        try (T inputStream = this.createFixture();){
            this.assertMarkSupportedEquals((ProxyInputStream)inputStream);
        }
    }

    @Test
    public void testMarkSupportedAfterClose() throws IOException {
        T shadow;
        try (T inputStream = this.createFixture();){
            shadow = inputStream;
        }
        this.assertMarkSupportedEquals((ProxyInputStream)shadow);
    }

    @Test
    public void testMarkSupportedOnNull() throws IOException {
        try (T fixture = this.createFixture();){
            this.assertMarkSupportedEquals((ProxyInputStream)fixture);
            fixture.setIn(null);
            Assertions.assertFalse((boolean)fixture.markSupported());
        }
    }

    @Test
    public void testRead() throws IOException {
        try (T inputStream = this.createFixture();){
            int found = inputStream.read();
            Assertions.assertEquals((int)97, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)98, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)99, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadAfterClose_ByteArrayInputStream() throws IOException {
        try (ProxyInputStreamFixture inputStream = new ProxyInputStreamFixture(new ByteArrayInputStream("abc".getBytes(StandardCharsets.UTF_8)));){
            ((InputStream)((Object)inputStream)).close();
            Assertions.assertNotEquals((int)-1, (int)((InputStream)((Object)inputStream)).read());
        }
    }

    @Test
    public void testReadAfterClose_ChannelInputStream() throws IOException {
        try (ProxyInputStreamFixture inputStream = new ProxyInputStreamFixture(Files.newInputStream(Paths.get("src/test/resources/org/apache/commons/io/abitmorethan16k.txt", new String[0]), new OpenOption[0]));){
            ((InputStream)((Object)inputStream)).close();
            Assertions.assertThrows(IOException.class, ((InputStream)((Object)inputStream))::read);
        }
    }

    @Test
    public void testReadAfterClose_CharSequenceInputStream() throws IOException {
        try (T inputStream = this.createFixture();){
            ((InputStream)inputStream).close();
            Assertions.assertEquals((int)-1, (int)((InputStream)inputStream).read());
        }
    }

    @Test
    public void testReadArrayAtMiddleFully() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest, 2, 3);
            Assertions.assertEquals((int)3, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 97, 98, 99}, (byte[])dest);
            found = inputStream.read(dest, 2, 3);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayAtStartFully() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest, 0, 5);
            Assertions.assertEquals((int)3, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99, 0, 0}, (byte[])dest);
            found = inputStream.read(dest, 0, 5);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayAtStartPartial() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest, 0, 2);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 0, 0, 0}, (byte[])dest);
            Arrays.fill(dest, (byte)0);
            found = inputStream.read(dest, 0, 2);
            Assertions.assertEquals((int)1, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{99, 0, 0, 0, 0}, (byte[])dest);
            found = inputStream.read(dest, 0, 2);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayFully() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest);
            Assertions.assertEquals((int)3, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99, 0, 0}, (byte[])dest);
            found = inputStream.read(dest);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayPartial() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[2];
            int found = inputStream.read(dest);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98}, (byte[])dest);
            Arrays.fill(dest, (byte)0);
            found = inputStream.read(dest);
            Assertions.assertEquals((int)1, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{99, 0}, (byte[])dest);
            found = inputStream.read(dest);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadEof() throws Exception {
        ByteArrayInputStream proxy = new ByteArrayInputStream(new byte[2]);
        try (ProxyInputStreamFixture inputStream = new ProxyInputStreamFixture(proxy);){
            Assertions.assertSame((Object)proxy, (Object)inputStream.unwrap());
            int found = inputStream.read();
            Assertions.assertEquals((int)0, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)0, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)-1, (int)found);
        }
    }

    @Test
    public void testSubclassAfterReadConsumer() throws Exception {
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        AtomicBoolean boolRef = new AtomicBoolean();
        try (ProxyInputStreamFixture bounded = ((ProxyInputStreamFixture.Builder)((ProxyInputStreamFixture.Builder)((ProxyInputStreamFixture.Builder)ProxyInputStreamFixture.builder().setInputStream(new ByteArrayInputStream(hello))).setAfterRead(null)).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume((InputStream)((Object)bounded));
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (ProxyInputStreamFixture bounded = ((ProxyInputStreamFixture.Builder)((ProxyInputStreamFixture.Builder)ProxyInputStreamFixture.builder().setInputStream(new ByteArrayInputStream(hello))).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertEquals((Object)"test exception message", (Object)((CustomIOException)Assertions.assertThrowsExactly(CustomIOException.class, () -> IOUtils.consume((InputStream)((Object)bounded)))).getMessage());
        }
    }

    private static final class ProxyInputStreamFixture
    extends ProxyInputStream {
        static Builder builder() {
            return new Builder();
        }

        ProxyInputStreamFixture(Builder builder) throws IOException {
            super((ProxyInputStream.AbstractBuilder)builder);
        }

        ProxyInputStreamFixture(InputStream proxy) {
            super(proxy);
        }

        static class Builder
        extends ProxyInputStream.AbstractBuilder<ProxyInputStreamFixture, Builder> {
            Builder() {
            }

            public ProxyInputStreamFixture get() throws IOException {
                return new ProxyInputStreamFixture(this);
            }
        }
    }
}

