/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenReader;
import org.apache.commons.io.input.ClosedReader;
import org.apache.commons.io.input.TaggedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedReaderTest {
    @Test
    public void testBrokenReader() {
        IOException exception = new IOException("test exception");
        TaggedReader reader = new TaggedReader((Reader)new BrokenReader(exception));
        IOException readyException = (IOException)Assertions.assertThrows(IOException.class, () -> ((TaggedReader)reader).ready());
        Assertions.assertTrue((boolean)reader.isCauseOf((Throwable)readyException));
        IOException rethrownReadyException = (IOException)Assertions.assertThrows(IOException.class, () -> reader.throwIfCauseOf((Throwable)readyException));
        Assertions.assertEquals((Object)exception, (Object)rethrownReadyException);
        IOException readException = (IOException)Assertions.assertThrows(IOException.class, () -> ((TaggedReader)reader).read());
        Assertions.assertTrue((boolean)reader.isCauseOf((Throwable)readException));
        IOException rethrownReadException = (IOException)Assertions.assertThrows(IOException.class, () -> reader.throwIfCauseOf((Throwable)readException));
        Assertions.assertEquals((Object)exception, (Object)rethrownReadException);
        IOException closeException = (IOException)Assertions.assertThrows(IOException.class, () -> ((TaggedReader)reader).close());
        Assertions.assertTrue((boolean)reader.isCauseOf((Throwable)closeException));
        IOException rethrownCloseException = (IOException)Assertions.assertThrows(IOException.class, () -> reader.throwIfCauseOf((Throwable)closeException));
        Assertions.assertEquals((Object)exception, (Object)rethrownCloseException);
    }

    @Test
    public void testEmptyReader() throws IOException {
        try (TaggedReader reader = new TaggedReader((Reader)ClosedReader.INSTANCE);){
            Assertions.assertFalse((boolean)reader.ready());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1], 0, 1));
        }
    }

    @Test
    public void testNormalReader() throws IOException {
        try (TaggedReader reader = new TaggedReader((Reader)new StringReader("abc"));){
            Assertions.assertTrue((boolean)reader.ready());
            Assertions.assertEquals((int)97, (int)reader.read());
            char[] buffer = new char[1];
            Assertions.assertEquals((int)1, (int)reader.read(buffer));
            Assertions.assertEquals((char)'b', (char)buffer[0]);
            Assertions.assertEquals((int)1, (int)reader.read(buffer, 0, 1));
            Assertions.assertEquals((char)'c', (char)buffer[0]);
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedReader reader = new TaggedReader((Reader)ClosedReader.INSTANCE);){
            Assertions.assertFalse((boolean)reader.isCauseOf((Throwable)exception));
            Assertions.assertFalse((boolean)reader.isCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
            reader.throwIfCauseOf((Throwable)exception);
            reader.throwIfCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        }
    }
}

