/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.file.TempFile;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ChunkedOutputStream;
import org.apache.commons.lang3.ArrayFill;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkedOutputStreamTest {
    private ByteArrayOutputStream newByteArrayOutputStream(final AtomicInteger numWrites) {
        return new ByteArrayOutputStream(){

            public void write(byte[] b, int off, int len) {
                numWrites.incrementAndGet();
                super.write(b, off, len);
            }
        };
    }

    @Test
    public void testBuildSetByteArrayOutputStream() throws IOException {
        AtomicInteger numWrites = new AtomicInteger();
        try (ByteArrayOutputStream baos = this.newByteArrayOutputStream(numWrites);
             ChunkedOutputStream chunked = ((ChunkedOutputStream.Builder)ChunkedOutputStream.builder().setOutputStream((OutputStream)baos)).get();){
            chunked.write(new byte[8193]);
            Assertions.assertEquals((int)2, (int)numWrites.get());
        }
        Assertions.assertThrows(IllegalStateException.class, () -> ChunkedOutputStream.builder().get());
    }

    @Test
    public void testBuildSetPath() throws IOException {
        try (TempFile tempFile = TempFile.create("test-", ".txt", new FileAttribute[0]);){
            byte[] fill = ArrayFill.fill((byte[])new byte[8193], (byte)97);
            Path tempPath = tempFile.get();
            try (ChunkedOutputStream chunked = ((ChunkedOutputStream.Builder)ChunkedOutputStream.builder().setPath(tempPath)).get();){
                chunked.write(fill);
            }
            Assertions.assertArrayEquals((byte[])fill, (byte[])Files.readAllBytes(tempPath));
        }
    }

    @Test
    public void testDefaultConstructor() throws IOException {
        AtomicInteger numWrites = new AtomicInteger();
        try (ByteArrayOutputStream baos = this.newByteArrayOutputStream(numWrites);
             ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)baos);){
            chunked.write(new byte[8193]);
            Assertions.assertEquals((int)2, (int)numWrites.get());
        }
    }

    @Test
    public void testNegativeChunkSize() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkedOutputStream((OutputStream)new ByteArrayOutputStream(), -1));
        try (ChunkedOutputStream os = ((ChunkedOutputStream.Builder)((ChunkedOutputStream.Builder)ChunkedOutputStream.builder().setOutputStream((OutputStream)new ByteArrayOutputStream())).setBufferSize(-1)).get();){
            Assertions.assertEquals((int)8192, (int)os.getChunkSize());
        }
    }

    @Test
    public void testWriteFourChunks() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        try (ByteArrayOutputStream baos = this.newByteArrayOutputStream(numWrites);
             ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)baos, 10);){
            chunked.write("0123456789012345678901234567891".getBytes());
            Assertions.assertEquals((int)4, (int)numWrites.get());
        }
    }

    @Test
    public void testZeroChunkSize() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkedOutputStream((OutputStream)new ByteArrayOutputStream(), 0));
        try (ChunkedOutputStream os = ((ChunkedOutputStream.Builder)((ChunkedOutputStream.Builder)ChunkedOutputStream.builder().setOutputStream((OutputStream)new ByteArrayOutputStream())).setBufferSize(0)).get();){
            Assertions.assertEquals((int)8192, (int)os.getChunkSize());
        }
    }
}

