/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.output.RandomAccessFileOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class RandomAccessFileOutputStreamTest {
    private static final String EXPECTED = "Put the message in the box";
    @TempDir
    public Path temporaryFolder;

    @Test
    public void testClose() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteInt.txt");
        Charset charset = StandardCharsets.US_ASCII;
        try (RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).setOpenOptions(new OpenOption[]{StandardOpenOption.WRITE})).get();){
            os.write(EXPECTED.getBytes(charset));
            os.close();
        }
        Assertions.assertEquals((Object)EXPECTED, (Object)new String(Files.readAllBytes(fixturePath), charset));
        os = ((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).get();
        if (os != null) {
            os.close();
        }
    }

    @Test
    public void testFlush() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteInt.txt");
        Charset charset = StandardCharsets.US_ASCII;
        try (RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).setOpenOptions(new OpenOption[]{StandardOpenOption.WRITE})).get();){
            byte[] bytes;
            for (byte element : bytes = EXPECTED.getBytes(charset)) {
                os.write((int)element);
                os.flush();
            }
        }
        Assertions.assertEquals((Object)EXPECTED, (Object)new String(Files.readAllBytes(fixturePath), charset));
        os = ((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).get();
        if (os != null) {
            os.close();
        }
    }

    @Test
    public void testWriteByteArray() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteInt.txt");
        Charset charset = StandardCharsets.US_ASCII;
        try (RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).setOpenOptions(new OpenOption[]{StandardOpenOption.WRITE})).get();){
            os.write(EXPECTED.getBytes(charset));
        }
        Assertions.assertEquals((Object)EXPECTED, (Object)new String(Files.readAllBytes(fixturePath), charset));
        os = ((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).get();
        if (os != null) {
            os.close();
        }
    }

    @Test
    public void testWriteByteArrayAt() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteInt.txt");
        Charset charset = StandardCharsets.US_ASCII;
        try (RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).setOpenOptions(new OpenOption[]{StandardOpenOption.WRITE})).get();){
            os.write(EXPECTED.getBytes(charset), 1, EXPECTED.length() - 2);
        }
        Assertions.assertEquals((Object)EXPECTED.subSequence(1, EXPECTED.length() - 1), (Object)new String(Files.readAllBytes(fixturePath), charset));
        os = ((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).get();
        if (os != null) {
            os.close();
        }
    }

    @Test
    public void testWriteGet() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteGet.txt");
        RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).setOpenOptions(new OpenOption[]{StandardOpenOption.WRITE})).get();
        if (os != null) {
            os.close();
        }
    }

    @Test
    public void testWriteGetDefault() throws IOException {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            RandomAccessFileOutputStream os = RandomAccessFileOutputStream.builder().get();
            if (os != null) {
                os.close();
            }
        });
    }

    @Test
    public void testWriteGetPathOnly() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteGet.txt");
        RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).get();
        if (os != null) {
            os.close();
        }
    }

    @Test
    public void testWriteInt() throws IOException {
        Path fixturePath = this.temporaryFolder.resolve("testWriteInt.txt");
        Charset charset = StandardCharsets.US_ASCII;
        try (RandomAccessFileOutputStream os = ((RandomAccessFileOutputStream.Builder)((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).setOpenOptions(new OpenOption[]{StandardOpenOption.WRITE})).get();){
            byte[] bytes;
            for (byte element : bytes = EXPECTED.getBytes(charset)) {
                os.write((int)element);
            }
        }
        Assertions.assertEquals((Object)EXPECTED, (Object)new String(Files.readAllBytes(fixturePath), charset));
        os = ((RandomAccessFileOutputStream.Builder)RandomAccessFileOutputStream.builder().setPath(fixturePath)).get();
        if (os != null) {
            os.close();
        }
    }
}

