/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v131.io.model.StreamHandle;
import org.openqa.selenium.devtools.v131.network.model.Headers;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LoadNetworkResourcePageResult {
    private final Boolean success;
    private final Optional<Number> netError;
    private final Optional<String> netErrorName;
    private final Optional<Number> httpStatusCode;
    private final Optional<StreamHandle> stream;
    private final Optional<Headers> headers;

    public LoadNetworkResourcePageResult(Boolean success, Optional<Number> netError, Optional<String> netErrorName, Optional<Number> httpStatusCode, Optional<StreamHandle> stream, Optional<Headers> headers) {
        this.success = Objects.requireNonNull(success, "success is required");
        this.netError = netError;
        this.netErrorName = netErrorName;
        this.httpStatusCode = httpStatusCode;
        this.stream = stream;
        this.headers = headers;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Optional<Number> getNetError() {
        return this.netError;
    }

    public Optional<String> getNetErrorName() {
        return this.netErrorName;
    }

    public Optional<Number> getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Optional<StreamHandle> getStream() {
        return this.stream;
    }

    public Optional<Headers> getHeaders() {
        return this.headers;
    }

    private static LoadNetworkResourcePageResult fromJson(JsonInput input) {
        Boolean success = false;
        Optional<Number> netError = Optional.empty();
        Optional<String> netErrorName = Optional.empty();
        Optional<Number> httpStatusCode = Optional.empty();
        Optional<StreamHandle> stream = Optional.empty();
        Optional<Headers> headers = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "success": {
                    success = input.nextBoolean();
                    continue block16;
                }
                case "netError": {
                    netError = Optional.ofNullable(input.nextNumber());
                    continue block16;
                }
                case "netErrorName": {
                    netErrorName = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "httpStatusCode": {
                    httpStatusCode = Optional.ofNullable(input.nextNumber());
                    continue block16;
                }
                case "stream": {
                    stream = Optional.ofNullable((StreamHandle)input.read(StreamHandle.class));
                    continue block16;
                }
                case "headers": {
                    headers = Optional.ofNullable((Headers)input.read(Headers.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LoadNetworkResourcePageResult(success, netError, netErrorName, httpStatusCode, stream, headers);
    }
}

