package org.openqa.selenium.devtools.v133.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired upon WebTransport creation.
 */
public class WebTransportCreated {

    private final org.openqa.selenium.devtools.v133.network.model.RequestId transportId;

    private final java.lang.String url;

    private final org.openqa.selenium.devtools.v133.network.model.MonotonicTime timestamp;

    private final java.util.Optional<org.openqa.selenium.devtools.v133.network.model.Initiator> initiator;

    public WebTransportCreated(org.openqa.selenium.devtools.v133.network.model.RequestId transportId, java.lang.String url, org.openqa.selenium.devtools.v133.network.model.MonotonicTime timestamp, java.util.Optional<org.openqa.selenium.devtools.v133.network.model.Initiator> initiator) {
        this.transportId = java.util.Objects.requireNonNull(transportId, "transportId is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.initiator = initiator;
    }

    /**
     * WebTransport identifier.
     */
    public org.openqa.selenium.devtools.v133.network.model.RequestId getTransportId() {
        return transportId;
    }

    /**
     * WebTransport request URL.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Timestamp.
     */
    public org.openqa.selenium.devtools.v133.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    /**
     * Request initiator.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v133.network.model.Initiator> getInitiator() {
        return initiator;
    }

    private static WebTransportCreated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v133.network.model.RequestId transportId = null;
        java.lang.String url = null;
        org.openqa.selenium.devtools.v133.network.model.MonotonicTime timestamp = null;
        java.util.Optional<org.openqa.selenium.devtools.v133.network.model.Initiator> initiator = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "transportId":
                    transportId = input.read(org.openqa.selenium.devtools.v133.network.model.RequestId.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v133.network.model.MonotonicTime.class);
                    break;
                case "initiator":
                    initiator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v133.network.model.Initiator.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WebTransportCreated(transportId, url, timestamp, initiator);
    }
}
