package org.openqa.selenium.devtools.v133.serviceworker;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class ServiceWorker {

    public static Command<Void> deliverPushMessage(java.lang.String origin, org.openqa.selenium.devtools.v133.serviceworker.model.RegistrationID registrationId, java.lang.String data) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        java.util.Objects.requireNonNull(registrationId, "registrationId is required");
        java.util.Objects.requireNonNull(data, "data is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("data", data);
        return new Command<>("ServiceWorker.deliverPushMessage", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("ServiceWorker.disable", Map.copyOf(params));
    }

    public static Command<Void> dispatchSyncEvent(java.lang.String origin, org.openqa.selenium.devtools.v133.serviceworker.model.RegistrationID registrationId, java.lang.String tag, java.lang.Boolean lastChance) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        java.util.Objects.requireNonNull(registrationId, "registrationId is required");
        java.util.Objects.requireNonNull(tag, "tag is required");
        java.util.Objects.requireNonNull(lastChance, "lastChance is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("tag", tag);
        params.put("lastChance", lastChance);
        return new Command<>("ServiceWorker.dispatchSyncEvent", Map.copyOf(params));
    }

    public static Command<Void> dispatchPeriodicSyncEvent(java.lang.String origin, org.openqa.selenium.devtools.v133.serviceworker.model.RegistrationID registrationId, java.lang.String tag) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        java.util.Objects.requireNonNull(registrationId, "registrationId is required");
        java.util.Objects.requireNonNull(tag, "tag is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("tag", tag);
        return new Command<>("ServiceWorker.dispatchPeriodicSyncEvent", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("ServiceWorker.enable", Map.copyOf(params));
    }

    public static Command<Void> inspectWorker(java.lang.String versionId) {
        java.util.Objects.requireNonNull(versionId, "versionId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("versionId", versionId);
        return new Command<>("ServiceWorker.inspectWorker", Map.copyOf(params));
    }

    public static Command<Void> setForceUpdateOnPageLoad(java.lang.Boolean forceUpdateOnPageLoad) {
        java.util.Objects.requireNonNull(forceUpdateOnPageLoad, "forceUpdateOnPageLoad is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("forceUpdateOnPageLoad", forceUpdateOnPageLoad);
        return new Command<>("ServiceWorker.setForceUpdateOnPageLoad", Map.copyOf(params));
    }

    public static Command<Void> skipWaiting(java.lang.String scopeURL) {
        java.util.Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("scopeURL", scopeURL);
        return new Command<>("ServiceWorker.skipWaiting", Map.copyOf(params));
    }

    public static Command<Void> startWorker(java.lang.String scopeURL) {
        java.util.Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("scopeURL", scopeURL);
        return new Command<>("ServiceWorker.startWorker", Map.copyOf(params));
    }

    public static Command<Void> stopAllWorkers() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("ServiceWorker.stopAllWorkers", Map.copyOf(params));
    }

    public static Command<Void> stopWorker(java.lang.String versionId) {
        java.util.Objects.requireNonNull(versionId, "versionId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("versionId", versionId);
        return new Command<>("ServiceWorker.stopWorker", Map.copyOf(params));
    }

    public static Command<Void> unregister(java.lang.String scopeURL) {
        java.util.Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("scopeURL", scopeURL);
        return new Command<>("ServiceWorker.unregister", Map.copyOf(params));
    }

    public static Command<Void> updateRegistration(java.lang.String scopeURL) {
        java.util.Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("scopeURL", scopeURL);
        return new Command<>("ServiceWorker.updateRegistration", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v133.serviceworker.model.ServiceWorkerErrorMessage> workerErrorReported() {
        return new Event<>("ServiceWorker.workerErrorReported", ConverterFunctions.map("errorMessage", org.openqa.selenium.devtools.v133.serviceworker.model.ServiceWorkerErrorMessage.class));
    }

    public static Event<java.util.List<org.openqa.selenium.devtools.v133.serviceworker.model.ServiceWorkerRegistration>> workerRegistrationUpdated() {
        return new Event<>("ServiceWorker.workerRegistrationUpdated", ConverterFunctions.map("registrations", input -> input.readArray(org.openqa.selenium.devtools.v133.serviceworker.model.ServiceWorkerRegistration.class)));
    }

    public static Event<java.util.List<org.openqa.selenium.devtools.v133.serviceworker.model.ServiceWorkerVersion>> workerVersionUpdated() {
        return new Event<>("ServiceWorker.workerVersionUpdated", ConverterFunctions.map("versions", input -> input.readArray(org.openqa.selenium.devtools.v133.serviceworker.model.ServiceWorkerVersion.class)));
    }
}
