/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.PublicApi;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public interface ExecutionResult {
    public List<GraphQLError> getErrors();

    public <T> T getData();

    public boolean isDataPresent();

    public Map<Object, Object> getExtensions();

    public Map<String, Object> toSpecification();

    public static ExecutionResult fromSpecification(Map<String, Object> specificationMap) {
        return ExecutionResultImpl.fromSpecification(specificationMap);
    }

    default public ExecutionResult transform(Consumer<Builder<?>> builderConsumer) {
        Object builder = ExecutionResult.newExecutionResult().from(this);
        builderConsumer.accept((Builder<?>)builder);
        return builder.build();
    }

    public static Builder<?> newExecutionResult() {
        return ExecutionResultImpl.newExecutionResult();
    }

    public static interface Builder<B extends Builder<B>> {
        public B from(ExecutionResult var1);

        public B data(Object var1);

        public B errors(List<GraphQLError> var1);

        public B addErrors(List<GraphQLError> var1);

        public B addError(GraphQLError var1);

        public B extensions(Map<Object, Object> var1);

        public B addExtension(String var1, Object var2);

        public ExecutionResult build();
    }
}

