/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Internal;
import graphql.collect.ImmutableMapWithNullValues;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.execution.ValuesResolver;
import graphql.language.Argument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.util.FpKit;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Internal
@NullMarked
public class ExecutionStepInfoFactory {
    public ExecutionStepInfo newExecutionStepInfoForListElement(ExecutionStepInfo executionInfo, ResultPath indexedPath) {
        GraphQLList fieldType = (GraphQLList)executionInfo.getUnwrappedNonNullType();
        GraphQLOutputType typeInList = (GraphQLOutputType)fieldType.getWrappedType();
        return executionInfo.transform(typeInList, executionInfo, indexedPath);
    }

    public ExecutionStepInfo createExecutionStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition, @Nullable GraphQLObjectType fieldContainer) {
        MergedField field = parameters.getField();
        ExecutionStepInfo parentStepInfo = parameters.getExecutionStepInfo();
        GraphQLOutputType fieldType = fieldDefinition.getType();
        List<GraphQLArgument> fieldArgDefs = fieldDefinition.getArguments();
        Supplier<ImmutableMapWithNullValues<String, Object>> argumentValues = ImmutableMapWithNullValues::emptyMap;
        if (!fieldArgDefs.isEmpty()) {
            argumentValues = ExecutionStepInfoFactory.getArgumentValues(executionContext, fieldArgDefs, field.getArguments());
        }
        return ExecutionStepInfo.newExecutionStepInfo().type(fieldType).fieldDefinition(fieldDefinition).fieldContainer(fieldContainer).field(field).path(parameters.getPath()).parentInfo(parentStepInfo).arguments(argumentValues).build();
    }

    private static @NonNull Supplier<ImmutableMapWithNullValues<String, Object>> getArgumentValues(ExecutionContext executionContext, List<GraphQLArgument> fieldArgDefs, List<Argument> fieldArgs) {
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        Supplier<ImmutableMapWithNullValues> argValuesSupplier = () -> {
            Map<String, Object> resolvedValues = ValuesResolver.getArgumentValues(codeRegistry, fieldArgDefs, fieldArgs, executionContext.getCoercedVariables(), executionContext.getGraphQLContext(), executionContext.getLocale());
            return ImmutableMapWithNullValues.copyOf(resolvedValues);
        };
        Supplier<ImmutableMapWithNullValues<String, Object>> argumentValues = FpKit.intraThreadMemoize(argValuesSupplier);
        return argumentValues;
    }
}

