/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized.nf;

import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.AstComparator;
import graphql.language.Directive;
import graphql.normalized.nf.NormalizedField;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Internal
public class NormalizedFieldsMerger {
    public static void merge(NormalizedField parent, List<NormalizedField> childrenWithSameResultKey, GraphQLSchema schema) {
        ArrayList possibleGroupsToMerge = new ArrayList();
        for (NormalizedField normalizedField : childrenWithSameResultKey) {
            boolean addToGroup = false;
            block1: for (Set set : possibleGroupsToMerge) {
                for (NormalizedField fieldInGroup : set) {
                    if (normalizedField.getFieldName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
                        addToGroup = true;
                        set.add(normalizedField);
                        continue block1;
                    }
                    if (!normalizedField.getFieldName().equals(fieldInGroup.getFieldName()) || !NormalizedFieldsMerger.sameArguments(normalizedField.getAstArguments(), fieldInGroup.getAstArguments()) || !NormalizedFieldsMerger.isFieldInSharedInterface(normalizedField, fieldInGroup, schema)) continue;
                    addToGroup = true;
                    set.add(normalizedField);
                    continue block1;
                }
            }
            if (addToGroup) continue;
            LinkedHashSet<NormalizedField> group = new LinkedHashSet<NormalizedField>();
            group.add(normalizedField);
            possibleGroupsToMerge.add(group);
        }
        for (Set set : possibleGroupsToMerge) {
            ArrayList<Set<NormalizedField>> listOfChildrenForGroup = new ArrayList<Set<NormalizedField>>();
            for (NormalizedField normalizedField : set) {
                LinkedHashSet<NormalizedField> childrenSets = new LinkedHashSet<NormalizedField>(normalizedField.getChildren());
                listOfChildrenForGroup.add(childrenSets);
            }
            boolean mergeable = NormalizedFieldsMerger.areFieldSetsTheSame(listOfChildrenForGroup);
            if (!mergeable) continue;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            ArrayList<Directive> mergedDirectives = new ArrayList<Directive>();
            set.forEach(f -> mergedObjects.addAll(f.getObjectTypeNames()));
            set.forEach(f -> mergedDirectives.addAll(f.getAstDirectives()));
            Iterator iterator = set.iterator();
            NormalizedField first = (NormalizedField)iterator.next();
            while (iterator.hasNext()) {
                NormalizedField next = (NormalizedField)iterator.next();
                parent.getChildren().remove(next);
            }
            first.setObjectTypeNames(linkedHashSet);
            first.setAstDirectives(mergedDirectives);
        }
    }

    private static boolean isFieldInSharedInterface(NormalizedField fieldOne, NormalizedField fieldTwo, GraphQLSchema schema) {
        String firstObject = fieldOne.getSingleObjectTypeName();
        String secondObject = fieldTwo.getSingleObjectTypeName();
        String fieldName = fieldOne.getFieldName();
        GraphQLObjectType objectTypeOne = schema.getObjectType(firstObject);
        GraphQLObjectType objectTypeTwo = schema.getObjectType(secondObject);
        List<GraphQLNamedOutputType> interfacesOne = objectTypeOne.getInterfaces();
        List<GraphQLNamedOutputType> interfacesTwo = objectTypeTwo.getInterfaces();
        Optional<GraphQLInterfaceType> firstInterfaceFound = interfacesOne.stream().filter(singleInterface -> singleInterface.getFieldDefinition(fieldName) != null).findFirst();
        Optional<GraphQLInterfaceType> secondInterfaceFound = interfacesTwo.stream().filter(singleInterface -> singleInterface.getFieldDefinition(fieldName) != null).findFirst();
        if (!firstInterfaceFound.isPresent() || !secondInterfaceFound.isPresent()) {
            return false;
        }
        return firstInterfaceFound.get().getName().equals(secondInterfaceFound.get().getName());
    }

    private static boolean areFieldSetsTheSame(List<Set<NormalizedField>> listOfSets) {
        if (listOfSets.size() == 0 || listOfSets.size() == 1) {
            return true;
        }
        Set<NormalizedField> first = listOfSets.get(0);
        Iterator<Set<NormalizedField>> iterator = listOfSets.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Set<NormalizedField> set = iterator.next();
            if (NormalizedFieldsMerger.compareTwoFieldSets(first, set)) continue;
            return false;
        }
        ArrayList<Set<NormalizedField>> nextLevel = new ArrayList<Set<NormalizedField>>();
        for (Set<NormalizedField> set : listOfSets) {
            for (NormalizedField fieldInSet : set) {
                nextLevel.add(new LinkedHashSet<NormalizedField>(fieldInSet.getChildren()));
            }
        }
        return NormalizedFieldsMerger.areFieldSetsTheSame(nextLevel);
    }

    private static boolean compareTwoFieldSets(Set<NormalizedField> setOne, Set<NormalizedField> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (NormalizedField field : setOne) {
            if (NormalizedFieldsMerger.isContained(field, setTwo)) continue;
            return false;
        }
        return true;
    }

    private static boolean isContained(NormalizedField searchFor, Set<NormalizedField> set) {
        for (NormalizedField field : set) {
            if (!NormalizedFieldsMerger.compareWithoutChildren(searchFor, field)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareWithoutChildren(NormalizedField one, NormalizedField two) {
        if (!one.getObjectTypeNames().equals(two.getObjectTypeNames())) {
            return false;
        }
        if (!Objects.equals(one.getAlias(), two.getAlias())) {
            return false;
        }
        if (!Objects.equals(one.getFieldName(), two.getFieldName())) {
            return false;
        }
        return NormalizedFieldsMerger.sameArguments(one.getAstArguments(), two.getAstArguments());
    }

    private static boolean sameArguments(List<Argument> arguments1, List<Argument> arguments2) {
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (Argument argument : arguments1) {
            Argument matchedArgument = NormalizedFieldsMerger.findArgumentByName(argument.getName(), arguments2);
            if (matchedArgument == null) {
                return false;
            }
            if (AstComparator.sameValue(argument.getValue(), matchedArgument.getValue())) continue;
            return false;
        }
        return true;
    }

    private static Argument findArgumentByName(String name, List<Argument> arguments) {
        for (Argument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }
}

