/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class GetNextMatchingRequest
implements HttpHandler {
    private static final Type MAP_OF_CAPABILITIES = new TypeToken<Map<String, Long>>(){}.getType();
    private static final Json JSON = new Json();
    private final Tracer tracer;
    private final NewSessionQueue queue;

    public GetNextMatchingRequest(Tracer tracer, NewSessionQueue queue) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.queue = Require.nonNull("New session queue", queue);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueue.getrequest");){
            Tags.HTTP_REQUEST.accept(span, req);
            Map stereotypesJson = (Map)Contents.fromJson(req, MAP_OF_CAPABILITIES);
            HashMap<Capabilities, Long> stereotypes = new HashMap<Capabilities, Long>();
            stereotypesJson.forEach((k, v) -> {
                Capabilities caps = (Capabilities)JSON.toType((String)k, (Type)((Object)Capabilities.class));
                stereotypes.put(caps, (Long)v);
            });
            List<SessionRequest> sessionRequestList = this.queue.getNextAvailable(stereotypes);
            HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson(Collections.singletonMap("value", sessionRequestList)));
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

