/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.Comment;
import graphql.language.IgnoredChars;
import graphql.language.Node;
import graphql.language.SourceLocation;
import java.util.List;
import java.util.Map;

@PublicApi
public abstract class AbstractNode<T extends Node>
implements Node<T> {
    private final SourceLocation sourceLocation;
    private final ImmutableList<Comment> comments;
    private final IgnoredChars ignoredChars;
    private final ImmutableMap<String, String> additionalData;

    public AbstractNode(SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars) {
        this(sourceLocation, comments, ignoredChars, ImmutableKit.emptyMap());
    }

    public AbstractNode(SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        Assert.assertNotNull(comments, () -> "comments can't be null");
        Assert.assertNotNull(ignoredChars, () -> "ignoredChars can't be null");
        Assert.assertNotNull(additionalData, () -> "additionalData can't be null");
        this.sourceLocation = sourceLocation;
        this.additionalData = ImmutableMap.copyOf(additionalData);
        this.comments = ImmutableList.copyOf(comments);
        this.ignoredChars = ignoredChars;
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public IgnoredChars getIgnoredChars() {
        return this.ignoredChars;
    }

    @Override
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    protected <V extends Node> V deepCopy(V nullableObj) {
        if (nullableObj == null) {
            return null;
        }
        return (V)nullableObj.deepCopy();
    }

    protected <V extends Node> List<V> deepCopy(List<? extends Node> list) {
        if (list == null) {
            return null;
        }
        return ImmutableKit.map(list, n -> n.deepCopy());
    }
}

