/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.util.Breadcrumb;
import graphql.util.FpKit;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeZipper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@PublicApi
public class NodeMultiZipper<T> {
    private final T commonRoot;
    private final ImmutableList<NodeZipper<T>> zippers;
    private final NodeAdapter<T> nodeAdapter;

    public NodeMultiZipper(T commonRoot, List<NodeZipper<T>> zippers, NodeAdapter<T> nodeAdapter) {
        this.commonRoot = Assert.assertNotNull(commonRoot);
        this.zippers = ImmutableList.copyOf(zippers);
        this.nodeAdapter = nodeAdapter;
    }

    private NodeMultiZipper(T commonRoot, List<NodeZipper<T>> zippers, NodeAdapter<T> nodeAdapter, Object dummy) {
        this.commonRoot = Assert.assertNotNull(commonRoot);
        this.zippers = ImmutableList.copyOf(zippers);
        this.nodeAdapter = nodeAdapter;
    }

    public static <T> NodeMultiZipper<T> newNodeMultiZipperTrusted(T commonRoot, List<NodeZipper<T>> zippers, NodeAdapter<T> nodeAdapter) {
        return new NodeMultiZipper<T>(commonRoot, zippers, nodeAdapter, null);
    }

    public T toRootNode() {
        if (this.zippers.size() == 0) {
            return this.commonRoot;
        }
        LinkedHashSet<NodeZipper<T>> curZippers = new LinkedHashSet<NodeZipper<T>>(this.zippers);
        while (curZippers.size() > 1) {
            List<NodeZipper<T>> deepestZippers = this.getDeepestZippers(curZippers);
            Map<T, ImmutableList<NodeZipper<T>>> sameParent = this.zipperWithSameParent(deepestZippers);
            ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>();
            Map<Object, NodeZipper> zipperByNode = FpKit.groupingByUniqueKey(curZippers, NodeZipper::getCurNode);
            for (Map.Entry<T, ImmutableList<NodeZipper<T>>> entry : sameParent.entrySet()) {
                NodeZipper<T> newZipper = this.moveUp(entry.getKey(), (List)entry.getValue());
                Optional<NodeZipper> zipperToBeReplaced = Optional.ofNullable(zipperByNode.get(entry.getKey()));
                zipperToBeReplaced.ifPresent(curZippers::remove);
                newZippers.add(newZipper);
            }
            curZippers.removeAll(deepestZippers);
            curZippers.addAll(newZippers);
        }
        Assert.assertTrue(curZippers.size() == 1, () -> "unexpected state: all zippers must share the same root node");
        return ((NodeZipper)curZippers.iterator().next()).toRoot();
    }

    public T getCommonRoot() {
        return this.commonRoot;
    }

    public List<NodeZipper<T>> getZippers() {
        return this.zippers;
    }

    public int size() {
        return this.zippers.size();
    }

    public NodeZipper<T> getZipperForNode(T node) {
        return FpKit.findOneOrNull(this.zippers, zipper -> zipper.getCurNode() == node);
    }

    public NodeMultiZipper<T> withReplacedZippers(List<NodeZipper<T>> zippers) {
        return new NodeMultiZipper<T>(this.commonRoot, zippers, this.nodeAdapter);
    }

    public NodeMultiZipper<T> withNewZipper(NodeZipper<T> newZipper) {
        ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>(this.zippers);
        newZippers.add(newZipper);
        return new NodeMultiZipper<T>(this.commonRoot, newZippers, this.nodeAdapter);
    }

    public NodeMultiZipper<T> withReplacedZipper(NodeZipper<T> oldZipper, NodeZipper<T> newZipper) {
        int index = this.zippers.indexOf(oldZipper);
        Assert.assertTrue(index >= 0, () -> "oldZipper not found");
        ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>(this.zippers);
        newZippers.set(index, newZipper);
        return new NodeMultiZipper<T>(this.commonRoot, newZippers, this.nodeAdapter);
    }

    public NodeMultiZipper<T> withReplacedZipperForNode(T currentNode, T newNode) {
        int index = FpKit.findIndex(this.zippers, zipper -> zipper.getCurNode() == currentNode);
        Assert.assertTrue(index >= 0, () -> "No current zipper found for provided node");
        NodeZipper<T> newZipper = ((NodeZipper)this.zippers.get(index)).withNewNode(newNode);
        ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>(this.zippers);
        newZippers.set(index, newZipper);
        return new NodeMultiZipper<T>(this.commonRoot, newZippers, this.nodeAdapter);
    }

    private List<NodeZipper<T>> getDeepestZippers(Set<NodeZipper<T>> zippers) {
        Map<Integer, ImmutableList<NodeZipper>> grouped = FpKit.groupingBy(zippers, astZipper -> astZipper.getBreadcrumbs().size());
        Integer maxLevel = Collections.max(grouped.keySet());
        return grouped.get(maxLevel);
    }

    private NodeZipper<T> moveUp(T parent, List<NodeZipper<T>> sameParent) {
        Assert.assertNotEmpty(sameParent, () -> "expected at least one zipper");
        HashMap<String, List<T>> childrenMap = new HashMap<String, List<T>>(this.nodeAdapter.getNamedChildren(parent));
        HashMap<String, Integer> indexCorrection = new HashMap<String, Integer>();
        sameParent = new ArrayList<NodeZipper<T>>(sameParent);
        sameParent.sort((zipper1, zipper2) -> {
            NodeZipper.ModificationType modificationType2;
            int index2;
            int index1 = zipper1.getBreadcrumbs().get(0).getLocation().getIndex();
            if (index1 != (index2 = zipper2.getBreadcrumbs().get(0).getLocation().getIndex())) {
                return Integer.compare(index1, index2);
            }
            NodeZipper.ModificationType modificationType1 = zipper1.getModificationType();
            if (modificationType1 == (modificationType2 = zipper2.getModificationType())) {
                return 0;
            }
            if (modificationType1 == NodeZipper.ModificationType.REPLACE) {
                return -1;
            }
            return modificationType1 == NodeZipper.ModificationType.INSERT_BEFORE ? -1 : 1;
        });
        for (NodeZipper<T> zipper : sameParent) {
            NodeLocation location = zipper.getBreadcrumbs().get(0).getLocation();
            Integer ixDiff = indexCorrection.getOrDefault(location.getName(), 0);
            int ix = location.getIndex() + ixDiff;
            String name = location.getName();
            ArrayList<T> childList = new ArrayList<T>((Collection)childrenMap.get(name));
            switch (zipper.getModificationType()) {
                case REPLACE: {
                    childList.set(ix, zipper.getCurNode());
                    break;
                }
                case DELETE: {
                    childList.remove(ix);
                    indexCorrection.put(name, ixDiff - 1);
                    break;
                }
                case INSERT_BEFORE: {
                    childList.add(ix, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                    break;
                }
                case INSERT_AFTER: {
                    childList.add(ix + 1, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                }
            }
            childrenMap.put(name, childList);
        }
        T newNode = this.nodeAdapter.withNewChildren(parent, childrenMap);
        List<Breadcrumb<T>> newBreadcrumbs = sameParent.get(0).getBreadcrumbs().subList(1, sameParent.get(0).getBreadcrumbs().size());
        return new NodeZipper<T>(newNode, newBreadcrumbs, this.nodeAdapter);
    }

    private Map<T, ImmutableList<NodeZipper<T>>> zipperWithSameParent(List<NodeZipper<T>> zippers) {
        return FpKit.groupingBy(zippers, NodeZipper::getParent);
    }
}

