/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.huffman;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.huffman.Codebooks;
import net.sourceforge.jaad.aac.syntax.IBitStream;

public class Huffman
implements Codebooks {
    private static final boolean[] UNSIGNED = new boolean[]{false, false, true, true, false, false, true, true, true, true, true};
    private static final int QUAD_LEN = 4;
    private static final int PAIR_LEN = 2;

    private Huffman() {
    }

    private static int findOffset(IBitStream _in, int[][] table) throws AACException {
        int j;
        int off = 0;
        int len = table[off][0];
        for (int cw = _in.readBits(len); cw != table[off][1]; cw |= _in.readBits(j)) {
            j = table[++off][0] - len;
            len = table[off][0];
            cw <<= j;
        }
        return off;
    }

    private static void signValues(IBitStream _in, int[] data, int off, int len) throws AACException {
        for (int i = off; i < off + len; ++i) {
            if (data[i] == 0 || !_in.readBool()) continue;
            data[i] = -data[i];
        }
    }

    private static int getEscape(IBitStream _in, int s2) throws AACException {
        boolean neg = s2 < 0;
        int i = 4;
        while (_in.readBool()) {
            ++i;
        }
        int j = _in.readBits(i) | 1 << i;
        return neg ? -j : j;
    }

    public static int decodeScaleFactor(IBitStream _in) throws AACException {
        int offset = Huffman.findOffset(_in, HCB_SF);
        return HCB_SF[offset][2];
    }

    public static void decodeSpectralData(IBitStream _in, int cb, int[] data, int off) throws AACException {
        int[][] HCB2 = CODEBOOKS[cb - 1];
        int offset = Huffman.findOffset(_in, HCB2);
        data[off] = HCB2[offset][2];
        data[off + 1] = HCB2[offset][3];
        if (cb < 5) {
            data[off + 2] = HCB2[offset][4];
            data[off + 3] = HCB2[offset][5];
        }
        if (cb < 11) {
            if (UNSIGNED[cb - 1]) {
                Huffman.signValues(_in, data, off, cb < 5 ? 4 : 2);
            }
        } else if (cb == 11 || cb > 15) {
            Huffman.signValues(_in, data, off, cb < 5 ? 4 : 2);
            if (Math.abs(data[off]) == 16) {
                data[off] = Huffman.getEscape(_in, data[off]);
            }
            if (Math.abs(data[off + 1]) == 16) {
                data[off + 1] = Huffman.getEscape(_in, data[off + 1]);
            }
        } else {
            throw new AACException("Huffman: unknown spectral codebook: " + cb);
        }
    }
}

