/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.io.test.ThrowOnCloseInputStream;
import org.apache.commons.io.test.ThrowOnFlushAndCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CopyUtilsTest {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    @Test
    public void testCopy_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        CopyUtils.copy(this.inData, (OutputStream)out);
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        CopyUtils.copy(this.inData, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_byteArrayToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = StandardCharsets.UTF_8.name();
        StringWriter writer = new StringWriter();
        CopyUtils.copy("data".getBytes(charsetName), (Writer)writer, charsetName);
        Assertions.assertEquals((Object)"data", (Object)writer.toString());
    }

    @Test
    public void testCopy_inputStreamToOutputStream() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        int count = CopyUtils.copy(in, (OutputStream)out);
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
        Assertions.assertEquals((int)this.inData.length, (int)count);
    }

    @Test
    public void testCopy_inputStreamToWriter() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        CopyUtils.copy(in, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)in.available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = StandardCharsets.UTF_8.name();
        StringWriter writer = new StringWriter();
        CopyUtils.copy(((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)new CharSequenceInputStream.Builder().setCharSequence("data")).setCharset(charsetName)).get(), (Writer)writer, charsetName);
        Assertions.assertEquals((Object)"data", (Object)writer.toString());
    }

    @Test
    public void testCopy_readerToOutputStream() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        CopyUtils.copy((Reader)reader, (OutputStream)out);
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStreamString() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        CopyUtils.copy(reader, (OutputStream)out, StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToWriter() throws Exception {
        InputStream in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream(in);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        int count = CopyUtils.copy((Reader)reader, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)count, (String)"The number of characters returned by copy is wrong");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_stringToOutputStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        CopyUtils.copy(str, (OutputStream)out);
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_stringToOutputStreamString() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        CopyUtils.copy(str, (OutputStream)out, StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCopy_stringToWriter() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII);
        CopyUtils.copy(str, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testCtor() {
        new CopyUtils();
    }
}

