/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOExceptionWithCauseTest {
    @Test
    public void testIOExceptionStringThrowable() {
        IllegalArgumentException cause = new IllegalArgumentException("cause");
        IOException exception = new IOException("message", cause);
        this.validate(exception, cause, "message");
    }

    @Test
    public void testIOExceptionThrowable() {
        IllegalArgumentException cause = new IllegalArgumentException("cause");
        IOException exception = new IOException(cause);
        this.validate(exception, cause, "java.lang.IllegalArgumentException: cause");
    }

    void validate(Throwable throwable, Throwable expectedCause, String expectedMessage) {
        Assertions.assertEquals((Object)expectedMessage, (Object)throwable.getMessage());
        Assertions.assertEquals((Object)expectedCause, (Object)throwable.getCause());
        Assertions.assertSame((Object)expectedCause, (Object)throwable.getCause());
    }
}

