/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.time.Duration;
import org.apache.commons.io.ThreadMonitor;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadMonitorTest {
    @Test
    public void testCompletedWithoutTimeout() {
        try {
            Thread monitor = ThreadMonitor.start(Duration.ofMillis(400L));
            TestUtils.sleep(1L);
            ThreadMonitor.stop(monitor);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Timed Out", (Throwable)e);
        }
    }

    @Test
    public void testNoTimeoutMinus1() {
        try {
            Thread monitor = ThreadMonitor.start(Duration.ofMillis(-1L));
            Assertions.assertNull((Object)monitor, (String)"Timeout -1, Monitor should be null");
            TestUtils.sleep(100L);
            ThreadMonitor.stop(monitor);
        }
        catch (Exception e) {
            Assertions.fail((String)("Timeout -1, threw " + e), (Throwable)e);
        }
    }

    @Test
    public void testNoTimeoutZero() {
        try {
            Thread monitor = ThreadMonitor.start(Duration.ZERO);
            Assertions.assertNull((Object)monitor, (String)"Timeout 0, Monitor should be null");
            TestUtils.sleep(100L);
            ThreadMonitor.stop(monitor);
        }
        catch (Exception e) {
            Assertions.fail((String)("Timeout 0, threw " + e), (Throwable)e);
        }
    }

    @Test
    public void testTimeout() {
        Assertions.assertThrows(InterruptedException.class, () -> {
            Thread monitor = ThreadMonitor.start(Duration.ofMillis(100L));
            TestUtils.sleep(400L);
            ThreadMonitor.stop(monitor);
        });
    }
}

