/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOTriFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOTriFunctionTest {
    @Test
    public void testAccept() throws IOException {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        IOTriFunction<AtomicReference, AtomicReference, AtomicReference, String> tri = (t2, u, v) -> {
            ref1.set(Character.valueOf('a'));
            ref2.set((short)1);
            ref3.set("z");
            return "ABC";
        };
        Assertions.assertEquals((Object)"ABC", (Object)tri.apply(ref1, ref2, ref3));
        Assertions.assertEquals((Character)Character.valueOf('a'), (Character)((Character)ref1.get()));
        Assertions.assertEquals((Short)1, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"z", ref3.get());
    }

    @Test
    public void testAndThenIOFunction() throws IOException {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        IOTriFunction<AtomicReference, AtomicReference, AtomicReference, String> tri = (t2, u, v) -> {
            ref1.set(Character.valueOf('a'));
            ref2.set((short)1);
            ref3.set("z");
            return "9";
        };
        IOFunction<String, BigInteger> after = t2 -> {
            ref1.set(Character.valueOf('b'));
            ref2.set((short)2);
            ref3.set("zz");
            return BigInteger.valueOf(Long.parseLong(t2)).add(BigInteger.ONE);
        };
        Assertions.assertEquals((Object)BigInteger.TEN, (Object)tri.andThen(after).apply(ref1, ref2, ref3));
        Assertions.assertEquals((Character)Character.valueOf('b'), (Character)((Character)ref1.get()));
        Assertions.assertEquals((Short)2, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"zz", ref3.get());
    }
}

