/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.MarkShieldInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MarkShieldInputStreamTest {
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterClose(int len) throws Exception {
        MarkTestableInputStream shadow;
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            Assertions.assertEquals((int)len, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)((InputStream)shadow).available());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterOpen(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            Assertions.assertEquals((int)len, (int)in.available());
        }
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(new MarkShieldInputStream(new BrokenInputStream((Throwable)new IOException())));
    }

    @Test
    public void testMarkIsNoOpWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(64L, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readLimit);
        }
    }

    @Test
    public void testMarkIsNoOpWhenUnderlyingSupports() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(64L, true, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readLimit);
        }
    }

    @Test
    public void testMarkSupportedIsFalseWhenUnderlyingFalse() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, false, false);){
            Assertions.assertFalse((boolean)((InputStream)is).markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream(is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @Test
    public void testMarkSupportedIsFalseWhenUnderlyingTrue() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, true, false);){
            Assertions.assertTrue((boolean)((InputStream)is).markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream(is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadAfterClose(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            Assertions.assertEquals((int)len, (int)in.available());
            in.close();
            Assertions.assertThrows(IOException.class, in::read);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadByteArrayAfterClose(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            Assertions.assertEquals((int)len, (int)in.available());
            in.close();
            Assertions.assertEquals((int)0, (int)in.read(new byte[0]));
            Assertions.assertThrows(IOException.class, () -> in.read(new byte[2]));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadByteArrayIntIntAfterClose(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream(new NullInputStream(len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream(in);){
            Assertions.assertEquals((int)len, (int)in.available());
            in.close();
            Assertions.assertEquals((int)0, (int)in.read(new byte[0], 0, 1));
            Assertions.assertEquals((int)0, (int)in.read(new byte[1], 0, 0));
            Assertions.assertThrows(IOException.class, () -> in.read(new byte[2], 0, 1));
        }
    }

    @Test
    public void testResetThrowsExceptionWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream(new NullInputStream(64L, false, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, msis::reset);
        }
    }

    @Test
    public void testResetThrowsExceptionWhenUnderlyingSupports() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream(new NullInputStream(64L, true, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, msis::reset);
        }
    }

    private static final class MarkTestableInputStream
    extends ProxyInputStream {
        int markcount;
        int readLimit;

        public MarkTestableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void mark(int readLimit) {
            ++this.markcount;
            this.readLimit = readLimit;
            super.mark(readLimit);
        }
    }
}

