/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.ClosedWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.TaggedWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedWriterTest {
    @Test
    public void testBrokenWriter() {
        IOException exception = new IOException("test exception");
        TaggedWriter writer = new TaggedWriter(new BrokenWriter(exception));
        try {
            writer.write(new char[]{'x'}, 0, 1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)writer.isCauseOf(e));
            try {
                writer.throwIfCauseOf(e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            writer.flush();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)writer.isCauseOf(e));
            try {
                writer.throwIfCauseOf(e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            writer.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)writer.isCauseOf(e));
            try {
                writer.throwIfCauseOf(e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testNormalWriter() throws IOException {
        try (StringBuilderWriter buffer = new StringBuilderWriter();){
            try (TaggedWriter writer = new TaggedWriter(buffer);){
                ((Writer)writer).write(97);
                ((Writer)writer).write(new char[]{'b'});
                ((Writer)writer).write(new char[]{'c'}, 0, 1);
                ((Writer)writer).flush();
            }
            Assertions.assertEquals((int)3, (int)buffer.getBuilder().length());
            Assertions.assertEquals((char)'a', (char)buffer.getBuilder().charAt(0));
            Assertions.assertEquals((char)'b', (char)buffer.getBuilder().charAt(1));
            Assertions.assertEquals((char)'c', (char)buffer.getBuilder().charAt(2));
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedWriter writer = new TaggedWriter(ClosedWriter.INSTANCE);){
            Assertions.assertFalse((boolean)writer.isCauseOf(exception));
            Assertions.assertFalse((boolean)writer.isCauseOf(new TaggedIOException(exception, UUID.randomUUID())));
            writer.throwIfCauseOf(exception);
            writer.throwIfCauseOf(new TaggedIOException(exception, UUID.randomUUID()));
        }
    }
}

