/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.awt;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.api.PictureWithMetadata;
import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;

public class AWTFrameGrab
extends FrameGrab {
    public static AWTFrameGrab createAWTFrameGrab(SeekableByteChannel _in) throws IOException, JCodecException {
        FrameGrab fg = FrameGrab.createFrameGrab(_in);
        return new AWTFrameGrab(fg.getVideoTrack(), fg.getDecoder());
    }

    public AWTFrameGrab(SeekableDemuxerTrack videoTrack, ContainerAdaptor decoder) {
        super(videoTrack, decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getFrame(File file, double second) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(file);
            BufferedImage bufferedImage = ((AWTFrameGrab)AWTFrameGrab.createAWTFrameGrab(ch).seekToSecondPrecise(second)).getFrameWithOrientation();
            return bufferedImage;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static BufferedImage getFrame(SeekableByteChannel file, double second) throws JCodecException, IOException {
        return ((AWTFrameGrab)AWTFrameGrab.createAWTFrameGrab(file).seekToSecondPrecise(second)).getFrame();
    }

    public BufferedImage getFrame() throws IOException {
        Picture nativeFrame = this.getNativeFrame();
        return nativeFrame == null ? null : AWTUtil.toBufferedImage(nativeFrame);
    }

    public BufferedImage getFrameWithOrientation() throws IOException {
        PictureWithMetadata nativeFrame = this.getNativeFrameWithMetadata();
        return nativeFrame == null ? null : AWTUtil.toBufferedImage(nativeFrame.getPicture(), nativeFrame.getOrientation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getFrame(File file, int frameNumber) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(file);
            BufferedImage bufferedImage = ((AWTFrameGrab)AWTFrameGrab.createAWTFrameGrab(ch).seekToFramePrecise(frameNumber)).getFrame();
            return bufferedImage;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static BufferedImage getFrame(SeekableByteChannel file, int frameNumber) throws JCodecException, IOException {
        return ((AWTFrameGrab)AWTFrameGrab.createAWTFrameGrab(file).seekToFramePrecise(frameNumber)).getFrame();
    }

    public static BufferedImage getFrame(SeekableDemuxerTrack vt, ContainerAdaptor decoder, int frameNumber) throws IOException, JCodecException {
        return ((AWTFrameGrab)new AWTFrameGrab(vt, decoder).seekToFramePrecise(frameNumber)).getFrame();
    }

    public static BufferedImage getFrame(SeekableDemuxerTrack vt, ContainerAdaptor decoder, double second) throws IOException, JCodecException {
        return ((AWTFrameGrab)new AWTFrameGrab(vt, decoder).seekToSecondPrecise(second)).getFrame();
    }

    public static BufferedImage getFrameSloppy(SeekableDemuxerTrack vt, ContainerAdaptor decoder, int frameNumber) throws IOException, JCodecException {
        return ((AWTFrameGrab)new AWTFrameGrab(vt, decoder).seekToFrameSloppy(frameNumber)).getFrame();
    }

    public static BufferedImage getFrameSloppy(SeekableDemuxerTrack vt, ContainerAdaptor decoder, double second) throws IOException, JCodecException {
        return ((AWTFrameGrab)new AWTFrameGrab(vt, decoder).seekToSecondSloppy(second)).getFrame();
    }
}

