/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.storage.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageMetadata {
    private final TimeSinceEpoch creationTime;
    private final Integer length;
    private final Number remainingBudget;
    private final Integer bytesUsed;

    public SharedStorageMetadata(TimeSinceEpoch creationTime, Integer length, Number remainingBudget, Integer bytesUsed) {
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime is required");
        this.length = Objects.requireNonNull(length, "length is required");
        this.remainingBudget = Objects.requireNonNull(remainingBudget, "remainingBudget is required");
        this.bytesUsed = Objects.requireNonNull(bytesUsed, "bytesUsed is required");
    }

    public TimeSinceEpoch getCreationTime() {
        return this.creationTime;
    }

    public Integer getLength() {
        return this.length;
    }

    public Number getRemainingBudget() {
        return this.remainingBudget;
    }

    public Integer getBytesUsed() {
        return this.bytesUsed;
    }

    private static SharedStorageMetadata fromJson(JsonInput input) {
        TimeSinceEpoch creationTime = null;
        Integer length = 0;
        Number remainingBudget = 0;
        Integer bytesUsed = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "creationTime": {
                    creationTime = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block12;
                }
                case "length": {
                    length = input.nextNumber().intValue();
                    continue block12;
                }
                case "remainingBudget": {
                    remainingBudget = input.nextNumber();
                    continue block12;
                }
                case "bytesUsed": {
                    bytesUsed = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageMetadata(creationTime, length, remainingBudget, bytesUsed);
    }
}

