/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.runtime.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v133.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v133.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v133.runtime.model.StackTrace;
import org.openqa.selenium.devtools.v133.runtime.model.Timestamp;
import org.openqa.selenium.json.JsonInput;

public class ConsoleAPICalled {
    private final Type type;
    private final List<RemoteObject> args;
    private final ExecutionContextId executionContextId;
    private final Timestamp timestamp;
    private final Optional<StackTrace> stackTrace;
    private final Optional<String> context;

    public ConsoleAPICalled(Type type, List<RemoteObject> args, ExecutionContextId executionContextId, Timestamp timestamp, Optional<StackTrace> stackTrace, Optional<String> context) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.args = Objects.requireNonNull(args, "args is required");
        this.executionContextId = Objects.requireNonNull(executionContextId, "executionContextId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.stackTrace = stackTrace;
        this.context = context;
    }

    public Type getType() {
        return this.type;
    }

    public List<RemoteObject> getArgs() {
        return this.args;
    }

    public ExecutionContextId getExecutionContextId() {
        return this.executionContextId;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Optional<StackTrace> getStackTrace() {
        return this.stackTrace;
    }

    @Beta
    public Optional<String> getContext() {
        return this.context;
    }

    private static ConsoleAPICalled fromJson(JsonInput input) {
        Type type = null;
        List args = null;
        ExecutionContextId executionContextId = null;
        Timestamp timestamp = null;
        Optional<StackTrace> stackTrace = Optional.empty();
        Optional<String> context = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block16;
                }
                case "args": {
                    args = input.readArray((java.lang.reflect.Type)((Object)RemoteObject.class));
                    continue block16;
                }
                case "executionContextId": {
                    executionContextId = (ExecutionContextId)input.read((java.lang.reflect.Type)((Object)ExecutionContextId.class));
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (Timestamp)input.read((java.lang.reflect.Type)((Object)Timestamp.class));
                    continue block16;
                }
                case "stackTrace": {
                    stackTrace = Optional.ofNullable((StackTrace)input.read((java.lang.reflect.Type)((Object)StackTrace.class)));
                    continue block16;
                }
                case "context": {
                    context = Optional.ofNullable(input.nextString());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleAPICalled(type, args, executionContextId, timestamp, stackTrace, context);
    }

    public static enum Type {
        LOG("log"),
        DEBUG("debug"),
        INFO("info"),
        ERROR("error"),
        WARNING("warning"),
        DIR("dir"),
        DIRXML("dirxml"),
        TABLE("table"),
        TRACE("trace"),
        CLEAR("clear"),
        STARTGROUP("startGroup"),
        STARTGROUPCOLLAPSED("startGroupCollapsed"),
        ENDGROUP("endGroup"),
        ASSERT("assert"),
        PROFILE("profile"),
        PROFILEEND("profileEnd"),
        COUNT("count"),
        TIMEEND("timeEnd");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

