/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.systeminfo.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v133.systeminfo.model.Size;
import org.openqa.selenium.json.JsonInput;

public class VideoDecodeAcceleratorCapability {
    private final String profile;
    private final Size maxResolution;
    private final Size minResolution;

    public VideoDecodeAcceleratorCapability(String profile, Size maxResolution, Size minResolution) {
        this.profile = Objects.requireNonNull(profile, "profile is required");
        this.maxResolution = Objects.requireNonNull(maxResolution, "maxResolution is required");
        this.minResolution = Objects.requireNonNull(minResolution, "minResolution is required");
    }

    public String getProfile() {
        return this.profile;
    }

    public Size getMaxResolution() {
        return this.maxResolution;
    }

    public Size getMinResolution() {
        return this.minResolution;
    }

    private static VideoDecodeAcceleratorCapability fromJson(JsonInput input) {
        String profile = null;
        Size maxResolution = null;
        Size minResolution = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "profile": {
                    profile = input.nextString();
                    continue block10;
                }
                case "maxResolution": {
                    maxResolution = (Size)input.read((Type)((Object)Size.class));
                    continue block10;
                }
                case "minResolution": {
                    minResolution = (Size)input.read((Type)((Object)Size.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VideoDecodeAcceleratorCapability(profile, maxResolution, minResolution);
    }
}

