/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import org.apache.commons.io.file.Counters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CountersEqualsAndHashCodeTest {
    CountersEqualsAndHashCodeTest() {
    }

    @Test
    void testBigIntegerCounterEquals() {
        this.testEquals(Counters.bigIntegerCounter(), Counters.bigIntegerCounter());
    }

    @Test
    void testBigIntegerHashCode() {
        this.testHashCodes(Counters.bigIntegerCounter(), Counters.bigIntegerCounter());
    }

    private void testEquals(Counters.Counter counter1, Counters.Counter counter2) {
        Assertions.assertEquals((Object)counter1, (Object)counter2);
        counter1.increment();
        Assertions.assertNotEquals((Object)counter1, (Object)counter2);
        counter2.increment();
        Assertions.assertEquals((Object)counter1, (Object)counter2);
    }

    private void testEqualsByteCounters(Counters.PathCounters counter1, Counters.PathCounters counter2) {
        Assertions.assertEquals((Object)counter1, (Object)counter2);
        counter1.getByteCounter().increment();
        Assertions.assertNotEquals((Object)counter1, (Object)counter2);
        counter2.getByteCounter().increment();
        Assertions.assertEquals((Object)counter1, (Object)counter2);
    }

    private void testEqualsDirectoryCounters(Counters.PathCounters counter1, Counters.PathCounters counter2) {
        Assertions.assertEquals((Object)counter1, (Object)counter2);
        counter1.getDirectoryCounter().increment();
        Assertions.assertNotEquals((Object)counter1, (Object)counter2);
        counter2.getDirectoryCounter().increment();
        Assertions.assertEquals((Object)counter1, (Object)counter2);
    }

    private void testEqualsFileCounters(Counters.PathCounters counter1, Counters.PathCounters counter2) {
        Assertions.assertEquals((Object)counter1, (Object)counter2);
        counter1.getFileCounter().increment();
        Assertions.assertNotEquals((Object)counter1, (Object)counter2);
        counter2.getFileCounter().increment();
        Assertions.assertEquals((Object)counter1, (Object)counter2);
    }

    private void testHashCodeFileCounters(Counters.PathCounters counter1, Counters.PathCounters counter2) {
        Assertions.assertEquals((int)counter1.hashCode(), (int)counter2.hashCode());
        counter1.getFileCounter().increment();
        Assertions.assertNotEquals((int)counter1.hashCode(), (int)counter2.hashCode());
        counter2.getFileCounter().increment();
        Assertions.assertEquals((int)counter1.hashCode(), (int)counter2.hashCode());
    }

    private void testHashCodes(Counters.Counter counter1, Counters.Counter counter2) {
        Assertions.assertEquals((int)counter1.hashCode(), (int)counter2.hashCode());
        counter1.increment();
        Assertions.assertNotEquals((int)counter1.hashCode(), (int)counter2.hashCode());
        counter2.increment();
        Assertions.assertEquals((int)counter1.hashCode(), (int)counter2.hashCode());
    }

    @Test
    void testLongCounterEquals() {
        this.testEquals(Counters.longCounter(), Counters.longCounter());
    }

    @Test
    void testLongCounterHashCodes() {
        this.testHashCodes(Counters.longCounter(), Counters.longCounter());
    }

    @Test
    void testLongCounterMixEquals() {
        this.testEquals(Counters.longCounter(), Counters.bigIntegerCounter());
        this.testEquals(Counters.bigIntegerCounter(), Counters.longCounter());
    }

    @Test
    void testLongPathCountersEqualsByteCounters() {
        this.testEqualsByteCounters(Counters.longPathCounters(), Counters.longPathCounters());
    }

    @Test
    void testLongPathCountersEqualsDirectoryCounters() {
        this.testEqualsDirectoryCounters(Counters.longPathCounters(), Counters.longPathCounters());
    }

    @Test
    void testLongPathCountersEqualsFileCounters() {
        this.testEqualsFileCounters(Counters.longPathCounters(), Counters.longPathCounters());
    }

    @Test
    void testLongPathCountersHashCodeFileCounters() {
        this.testHashCodeFileCounters(Counters.longPathCounters(), Counters.longPathCounters());
    }

    @Test
    void testMix() {
        this.testHashCodeFileCounters(Counters.longPathCounters(), Counters.bigIntegerPathCounters());
    }
}

